package cn.com.duiba.activity.center.biz.pool;

import com.alibaba.fastjson.JSONObject;
import org.springframework.util.Assert;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolDuibaService {

	public static final int PriorityHigh=10;
	public static final int PriorityNormal=5;
	public static final int PriorityLow=1;

	/**
	 * 线程池最大线程数
	 */
	private static final int PoolMaxThread=50;

	private static final ThreadPoolDuibaService service=new ThreadPoolDuibaService();

	public static ThreadPoolDuibaService get(){
		return service;
	}

	private final PriorityBlockingQueue<Runnable> workQueue = new PriorityBlockingQueue<Runnable>();
	private final ThreadPoolExecutor pool;

	private ThreadPoolDuibaService(){
		pool = new ThreadPoolExecutor(PoolMaxThread, PoolMaxThread,	0L, TimeUnit.SECONDS, workQueue);
	}
	/**
	 * 提交兑吧任务
	 * @param runnable
	 * @param priority
	 */
	public void submit(Runnable runnable,int priority){
		pool.execute(new DuibaRunnable(runnable, priority));
	}

	public JSONObject dumpDetail(){
		JSONObject o=new JSONObject();
		o.put("runningStat", getRunningStat());
		o.put("waitRunStat", getWaitRunStat());
		return o;
	}

	public int dumpSize(){
		return getRunningStat()+getWaitRunStat();
	}

	public boolean isBusy(){
		int size=dumpSize();
		if(size>100){
			return true;
		}
		return false;
	}

	public class DuibaRunnable implements Runnable,Comparable<DuibaRunnable>{
		private int priority;
		private Runnable runnable;
		public DuibaRunnable(Runnable runnable,int priority){
			Assert.notNull(runnable);
			this.runnable=runnable;
			this.priority=priority;
		}

		@Override
		public void run() {
			runnable.run();
		}

		@Override
		public int compareTo(DuibaRunnable o) {
			if (this.getPriority() < o.getPriority()) {
				return 1;
			}
			if (this.getPriority() > o.getPriority()) {
				return -1;
			}
			return 0;
		}

		public int getPriority() {
			return priority;
		}

	}

	public Integer getRunningStat() {
		return pool.getActiveCount();
	}
	public Integer getWaitRunStat() {
		return pool.getQueue().size();
	}
}
