/**
 * Project Name:activity-center-biz
 * File Name:RemoteActivityPrizeOptionServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.prize
 * Date:2016年7月26日下午4:05:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.prize;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.remoteservice.prize.RemoteActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityPrizeOptionServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午4:05:28 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteActivityPrizeOptionServiceImpl implements RemoteActivityPrizeOptionService{
    
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;

    @Override
    public DubboResult<Boolean> delOption(Long optionId) {
        return DubboResult.successResult(activityPrizeOptionService.deleteOption(optionId));
    }

    @Override
    public DubboResult<Long> saveOrUpdateOption(ActivityPrizeOptionDto prizeOption) {
        return DubboResult.successResult(activityPrizeOptionService.saveOrUpdateOption(prizeOption));
    }

    @Override
    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigId(Long configId,String activityType) {
        return DubboResult.successResult(activityPrizeOptionService.queryActivityOptionsByConfigId(configId, activityType));
    }

    @Override
    public DubboResult<ActivityPrizeOptionDto> find(Long id) {
        return DubboResult.successResult(activityPrizeOptionService.find(id));
    }

}

