package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteQuizzAppOrderService;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzAppOrderService;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class RemoteQuizzAppOrderServiceImpl implements
		RemoteQuizzAppOrderService {

	@Autowired
	private QuizzAppOrderService quizzAppOrderService;
	
	@Override
	public List<QuizzOrdersDto> findQuizzOrderLimit50(Long appId,
			Long activityId) {
		return quizzAppOrderService.findQuizzOrderLimit50(appId, activityId);
	}

	@Override
	public List<QuizzOrdersDto> findByLimit(Map<String, Object> map) {
		return quizzAppOrderService.findByLimit(map);
	}

	@Override
	public Long totalCount(Map<String, Object> map) {
		return quizzAppOrderService.totalCount(map);
	}

	@Override
	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(
			List<Long> ids, Long appId) {
		return quizzAppOrderService.countFailByOperatingActivityIds(ids, appId);
	}
	
	@Override
	public QuizzOrdersDto insert(QuizzOrdersDto quizzOrdersDto, long id){
		quizzAppOrderService.insert(quizzOrdersDto, id);
		return quizzOrdersDto;
	}

}
