package cn.com.duiba.activity.center.biz.remoteservice.impl.seconds_kill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.SeckillOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.seconds_kill.RemoteSeckillAppOrderService;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.SeckillOrdersEntity;
import cn.com.duiba.activity.center.biz.service.seconds_kill_app.SeckillAppOrderService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

@Service
public class RemoteSeckillAppOrderServiceImpl implements RemoteSeckillAppOrderService{
	@Autowired
	private SeckillAppOrderService seckillAppOrderService;

	@Override
	public DubboResult<List<SeckillOrdersDto>> findByLimit(Map<String, Object> queryMap) {
		try{
			List<SeckillOrdersEntity> liste= seckillAppOrderService.findByLimit(queryMap);
			List<SeckillOrdersDto> listd = new ArrayList<SeckillOrdersDto>();
			ObjectUtil.convertList(liste, listd, SeckillOrdersDto.class);
			return DubboResult.successResult(listd);
		}catch(Exception e){
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> totalCount(Map<String, Object> queryMap) {
		try{
			return DubboResult.successResult(seckillAppOrderService.totalCount(queryMap));
		}catch(Exception e){
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<DeveloperActivityStatisticsDto>> countFailByOperatingActivityIds(List<Long> ids, Long appId) {
		try{
			List<DeveloperActivityStatisticsEntity> liste= seckillAppOrderService.countFailByOperatingActivityIds(ids,appId);
			List<DeveloperActivityStatisticsDto> listd = new ArrayList<DeveloperActivityStatisticsDto>();
			ObjectUtil.convertList(liste, listd, DeveloperActivityStatisticsDto.class);
			return DubboResult.successResult(listd);
		}catch(Exception e){
			return DubboResult.failResult(e.getMessage());
		}
	}

}
