package cn.com.duiba.activity.center.biz.service.asynctask.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.asynctask.OperatingActivityAsyncTaskService;

@Component
public class OperatingActivityAsyncTaskServiceImpl implements OperatingActivityAsyncTaskService, InitializingBean {

	private static final Logger log = LoggerFactory.getLogger(OperatingActivityAsyncTaskServiceImpl.class);

	@Autowired
	private OperatingActivityService operatingActivityService;

	private Map<Long, AtomicInteger> countJoinNum = new ConcurrentHashMap<Long, AtomicInteger>();

	// 初始化一个固定线程池
	private ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, new ThreadFactory() {
		private int i = 0;

		@Override
		public Thread newThread(Runnable runnable) {
			return new Thread(runnable, "Thread-ActivityJoinNum-" + (i++));
		}

	});

	@Override
	public void afterPropertiesSet() throws Exception {
		// 启动一个定时任务每 1000ms 更新一次中奖人数
		scheduled.scheduleWithFixedDelay(new Runnable() {
			@Override
			public void run() {
				try {
					for (Map.Entry<Long, AtomicInteger> entry : countJoinNum.entrySet()) {
						if (entry.getValue().intValue() > 0) {
							long operatingActivityId = entry.getKey();
							int count = entry.getValue().intValue();
							countJoinNum.put(operatingActivityId, new AtomicInteger(0));
							operatingActivityService.updateVisitTimes(operatingActivityId, count);
						}
					}
				} catch (Exception e) {
					log.error("updateJoinNum:", e);
				}
			}

		}, 1000, 1000, TimeUnit.MILLISECONDS);
	}

	@Override
	public synchronized void increaseJoinNum(Long operatingActivityId) {
		AtomicInteger count = countJoinNum.get(operatingActivityId);
		if (count == null) {
			count = new AtomicInteger(1);
		} else {
			count.incrementAndGet();
		}
		countJoinNum.put(operatingActivityId, count);
	}

}
