package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionStockDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionStockEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class DuibaQuestionStockServiceImpl implements DuibaQuestionStockService {
    @Resource
    private DuibaQuestionStockDao duibaQuestionStockDao;

    @Override
    public int subStock(Long id, Integer subNumber) {
        return duibaQuestionStockDao.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return duibaQuestionStockDao.addStock(id, addNumber);
    }

    @Override
    public DuibaQuestionStockDto findRemaining(Long questionOptionId, String type) {
        return BeanUtils.copy(duibaQuestionStockDao.findRemaining(questionOptionId, type), DuibaQuestionStockDto.class);
    }

    @Override
    public DuibaQuestionStockDto findByQuestionOptionId(Long questionOptionId) {
        return BeanUtils.copy(duibaQuestionStockDao.findByQuestionOptionId(questionOptionId), DuibaQuestionStockDto.class);
    }

    @Override
    public List<DuibaQuestionStockDto> findByQuestionOptionIds(List<Long> list) {
        return BeanUtils.copyList(duibaQuestionStockDao.findByQuestionOptionIds(list), DuibaQuestionStockDto.class);
    }

    @Override
    public int updateStockAdd(Long id, Integer stockAdd, String type) {
        return duibaQuestionStockDao.updateStockAdd(id, stockAdd, type);
    }

    @Override
    public int updateStockSub(Long id, Integer stockSub, String type) {
        return duibaQuestionStockDao.updateStockSub(id, stockSub, type);
    }

    @Override
    public void add(DuibaQuestionStockDto questionStockDO) {
        DuibaQuestionStockEntity e = BeanUtils.copy(questionStockDO, DuibaQuestionStockEntity.class);
        duibaQuestionStockDao.add(e);
        questionStockDO.setId(e.getId());
    }

    @Override
    public void addBatch(List<DuibaQuestionStockDto> list) {
        duibaQuestionStockDao.addBatch(BeanUtils.copyList(list, DuibaQuestionStockEntity.class));
    }
}
