package cn.com.duiba.activity.center.biz.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;

public class AssembleTool {

	public static String assembleUrl(String url,Map<String, String> params){
		if(url.contains("?")){
			url+="&";
		}else{
			url+="?";
		}
		for(String key:params.keySet()){
			try {
				if(params.get(key)==null || params.get(key).length()==0){
					url+=key+"="+params.get(key)+"&";
				}else{
					url+=key+"="+URLEncoder.encode(params.get(key), "utf-8")+"&";
				}
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}
		return url;
	}
	
	public static HttpPost assembleRequest(String url,Map<String, String>params){
		List<NameValuePair> pairs = new ArrayList<NameValuePair>(params.size());
        for(Map.Entry<String,String> entry : params.entrySet()){
            String value = entry.getValue();
            if(value != null){
                pairs.add(new BasicNameValuePair(entry.getKey(),value));
            }
        }
		HttpPost post=new HttpPost(url);
		post.setEntity(new UrlEncodedFormEntity(pairs,Charset.forName("utf-8")));
		return post;
	}
	
}
