/**
 * Project Name:activity-center-biz
 * File Name:XMemCacheClient.java
 * Package Name:cn.com.duiba.activity.center.biz.tools
 * Date:2016年7月29日下午8:07:06
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.tools;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.KestrelCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.utils.AddrUtil;

/**
 * ClassName:XMemCacheClient <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午8:07:06 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class XMemCacheClient implements InitializingBean{
    private static Logger logger = LoggerFactory.getLogger(XMemCacheClient.class);
    private MemcachedClient memcachedClient;
    private final String CACHE_NAME = XMemCacheClient.class.getName();
    
    private String servers;
    private String authInfos;
    private String username;
    private String password;
    private MemcachedSessionLocator sessionLocator;
    //TEXT/BINARY
    private String protocol;
    private int connectionPoolSize;
    private int connectionTimeout = MemcachedClient.DEFAULT_CONNECT_TIMEOUT;
    private int operationTimeout = 1000;//(int) MemcachedClient.DEFAULT_OP_TIMEOUT;
    private boolean enableHeartBeat;
    
    public String getServers() {
        return servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }
    
    public String getAuthInfos() {
        return authInfos;
    }

    public void setAuthInfos(String authInfos) {
        this.authInfos = authInfos;
    }
    
    private void initClient() {
        if (memcachedClient != null) {
            logger.info(CACHE_NAME + " already initialized");
            return;
        }

        String[] servers = StringUtils.split(this.getServers(), ",");
        String[] authInfos = StringUtils.split(this.getAuthInfos(), ",");
        List<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();

        Map<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
        int i = 0;
        for (String server : servers) {
            InetSocketAddress address = AddrUtil.getOneAddress(server);
            addressList.add(address);
            if(authInfos != null && authInfos.length > 0) {//优先使用authInfos中配置的用户名和密码,如果没有再使用username、password配置
                if (authInfos != null && authInfos.length > i) {
                    String authInfo = authInfos[i];
                    String[] temp = authInfo.split(":");
                    if (temp.length >= 1) {
                        authInfoMap.put(address, AuthInfo.plain(temp[0], temp[1]));
                        logger.info("auth " + server + " with username:" + temp[0] + ",password:" + temp[1]);
                    }
                }
            }else if(!StringUtils.isBlank(username) && !StringUtils.isBlank(password)){
                authInfoMap.put(address, AuthInfo.plain(username, password));
            }
            i++;
        }

        MemcachedClientBuilder builder = new XMemcachedClientBuilder(addressList);// weights
        builder.setAuthInfoMap(authInfoMap);

        if (sessionLocator != null) {
            builder.setSessionLocator(sessionLocator);
        }

        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(1024);
        builder.setTranscoder(transcoder);

        //TEXT/BINARY 默认BINARY
        if (StringUtils.isBlank(protocol) || protocol.equals("BINARY")) {
            builder.setCommandFactory(new BinaryCommandFactory());
        }else if(protocol.equals("TEXT")){
            builder.setCommandFactory(new TextCommandFactory());
        }else if(protocol.equals("KESTREL")){
            builder.setCommandFactory(new KestrelCommandFactory());
        }
        builder.setKeyProvider(new KeyProvider() {

            @Override
            public String process(String key) {
                if (key == null) {
                    return null;
                }
                return key.trim();// "prefix_" +
            }
        });
        builder.setHealSessionInterval(2000);//连接断开两秒后尝试重连
        // builder.setSessionLocator(new KetamaMemcachedSessionLocator());// 一致性哈希（consistent hash)
        // builder.setSessionLocator(new ElectionMemcachedSessionLocator());
        // builder.setTranscoder(new SerializingTranscoder());
        //builder.getConfiguration().setCheckSessionTimeoutInterval();
        //builder.getConfiguration().setSessionIdleTimeout();

        // builder.getTranscoder().setPackZeros(true);
        // builder.getTranscoder().setPrimitiveAsString(false);

        // memcachedClient.setOptimizeGet(true);
        // memcachedClient.setOptimizeMergeBuffer(true);
        // memcachedClient.setPrimitiveAsString(false);
        // memcachedClient.setSanitizeKeys(false);

        if (connectionPoolSize > 0) {
            builder.setConnectionPoolSize(connectionPoolSize);// 设置多个连接会有bug。1个足够了
        }
        // builder.setSocketOption(StandardSocketOption.SO_RCVBUF, 32 * 1024); // 设置接收缓存区为32K，默认16K
        // builder.setSocketOption(StandardSocketOption.SO_SNDBUF, 16 * 1024); // 设置发送缓冲区为16K，默认为8K

        try {
            memcachedClient = builder.build();

            memcachedClient.setConnectTimeout(connectionTimeout);
            memcachedClient.setOpTimeout(operationTimeout);
            memcachedClient.setEnableHeartBeat(enableHeartBeat);
            logger.info(addressList + " initialized{}");
        } catch (IOException e) {
            logger.error("Initialize " + getClass() + " error", e);
            throw new RuntimeException("Initialize " + getClass() + " error", e);
        }

        try {
            // 去除shutdownhook,以防kill程序时memcached先关闭了而导致的一些问题
            Field field = memcachedClient.getClass().getDeclaredField("shutdownHookThread");
            field.setAccessible(true);
            Thread shutdownHookThread = (Thread)field.get(memcachedClient);
            Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        } catch (Exception e) {
            logger.error("warn: getField:shutdownHookThread error", e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        initClient();
    }

    
    public MemcachedClient getMemcachedClient() {
        return memcachedClient;
    }

    
    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    
    public String getUsername() {
        return username;
    }

    
    public void setUsername(String username) {
        this.username = username;
    }

    
    public String getPassword() {
        return password;
    }

    
    public void setPassword(String password) {
        this.password = password;
    }

    
    public MemcachedSessionLocator getSessionLocator() {
        return sessionLocator;
    }

    
    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        this.sessionLocator = sessionLocator;
    }

    
    public String getProtocol() {
        return protocol;
    }

    
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    
    public int getConnectionPoolSize() {
        return connectionPoolSize;
    }

    
    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    
    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    
    public int getOperationTimeout() {
        return operationTimeout;
    }

    
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    
    public boolean isEnableHeartBeat() {
        return enableHeartBeat;
    }

    
    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }
}

