package cn.com.duiba.activity.center.biz.tools.service;

import java.util.Date;

import net.rubyeye.xmemcached.GetsResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.service.domain.dataobject.OrdersDO;

/**
 * 今日数据统计
 * @author houwen
 *
 */
@Service
public class TodayCountService {
	private static Logger log = LoggerFactory.getLogger(TodayCountService.class);
	@Autowired @Qualifier("memCacheClient")
	private XMemCacheClient xMemCacheClient;
	/**
	 * 预计数据缓存前缀（避免与其他key重复）
	 */
	private final String EXPECT_NAMESPACE = "expectnamespace";
	
	/**
	 * 添加积分
	 */
	public void addExpectByCredits(Long appId, Long credits){
		try {
			if(credits>0){
				String creditsKey = EXPECT_NAMESPACE+appId+"credits";
				if(setByCas(creditsKey, credits.intValue(), 1)==2){
				    xMemCacheClient.getMemcachedClient().set(creditsKey, DateUtil.getToTomorrowSeconds(), credits.intValue());
				}
			}
		} catch (Exception e) {
			log.error("添加积分异常",e);   
		}
	}
	
	private Integer setByCas(final String key, final int value, final int type) {
		Integer result = null;
		boolean loop = true;
		try {
			int loopNum = 0;
			while (loop) {
				if(loopNum >= 10){
					loop = false;
					result=1;//系统繁忙
					break;
				}
				GetsResponse<Object> last = xMemCacheClient.getMemcachedClient().gets(key);
				if (last == null) {
					loop = false;
					result=2;//缓存对象为空
					break;
				} else {
					int nextValue = (Integer)last.getValue();
					if(type>0){
						nextValue = nextValue+value;
					}else if(type<0){
						if(nextValue>=value){
							nextValue = nextValue-value;
						}else{
							nextValue = 0;
						}
					}else{
						loop = false;
						result=4;//参数错误
						break;
					}
					boolean bo = xMemCacheClient.getMemcachedClient().cas(key,DateUtil.getToTomorrowSeconds(),nextValue,last.getCas());
					if(bo){
					    loop = false;
					    result = 0;
					    break;
					}
				}
				loopNum++;
			}
		} catch (Exception e) {
			result=5;
			log.error("更新缓存异常:",e);
		}
		return result;
	}
	
	public class ExpectVO{
		private Integer orderCount = 0; //订单数
		private Integer credits = 0; //消耗积分
		private Integer actualPrice = 0; //消耗金额
		public Integer getOrderCount() {
			return orderCount;
		}
		public void setOrderCount(Integer orderCount) {
			this.orderCount = orderCount;
		}
		public Integer getCredits() {
			return credits;
		}
		public void setCredits(Integer credits) {
			this.credits = credits;
		}
		public Integer getActualPrice() {
			return actualPrice;
		}
		public void setActualPrice(Integer actualPrice) {
			this.actualPrice = actualPrice;
		}
	}

}
