package cn.com.duiba.activity.center.biz.dao.ngame_con;


import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;

import java.util.Date;
import java.util.List;

/**
 * ngame_orders按consumer分表
 */
public interface NgameOrdersConsumerDao {

	//from NgameOrdersSimpleDAO in credits

	public NgameOrdersEntity find(Long consumerId, Long gameOrderId);
	
	public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId);

	public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);
	
	public List<NgameOrdersEntity> findByIds(Long consumerId, List<Long> ids);

	//from NgameOrderTextChangeDAO in credits

	/**
	 * 添加活动工具订单
	 */
	public int insert(NgameOrdersEntity ngameOrdersDto);

	public int updateDeveloperBizId(Long consumerId,long id, String bizId);

	public int updateMainOrderId(Long consumerId,long id, Long mainOrderId, String mainOrderNum);

	//from NgameOrdersStatusChangeDAO in credits

	public int updateStatusToConsumeSuccess(Long consumerId,Long gameOrderId);

	public int updateStatusToSuccess(Long consumerId,Long gameOrderId, Long gameOrderExtraId);

	public int updateStatusToFail(Long consumerId,Long gameOrderId, String error4admin, String error4developer, String error4consumer);

	public int updateExchangeStatusToWaitOpen(Long consumerId,Long gameOrderId, String gameDataStr);

	public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId,Long gameOrderId, String gameDataStr, Long gameOrderExtraId);

	public int updateExchangeStatusToWait(Long consumerId,Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);

	public int updateExchangeStatusToOverdue(Long gameOrderId, Long consumerId, String error4admin, String error4developer, String error4consumer);

	public int updateExchangeStatusToFail(Long consumerId,Long gameOrderId, String error4admin, String error4developer, String error4consumer);

	public int doTakePrize(Long consumerId,Long gameOrderId);

	public int rollbackTakePrize(Long consumerId,Long gameOrderId);

	public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId,Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);
	
	public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long gameOrderExtraId);
	
}
