package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockManualChangeDao;
import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockManualChangeEntity;

import com.google.common.collect.Maps;

@Repository
public class DuibaQuizzStockManualChangeDaoImpl extends ActivityBaseDao implements DuibaQuizzStockManualChangeDao {

    @Override
    public List<DuibaQuizzStockManualChangeEntity> findByStockId(Long quizzStockId) {
        return selectList("findByStockId", quizzStockId);
    }

    @Override
    public void addBatch(List<DuibaQuizzStockManualChangeEntity> list) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("list", list);
        insert("addBatch", params);
    }

    @Override
    public void add(DuibaQuizzStockManualChangeEntity quizzStockManualChangeDO) {
        insert("add", quizzStockManualChangeDO);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }
}
