package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteDuibaGuessAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessAppSpecifyService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/7.
 */
@Service
public class RemoteDuibaGuessAppSpecifyServiceImpl implements RemoteDuibaGuessAppSpecifyService {
    @Resource
    private DuibaGuessAppSpecifyService duibaGuessAppSpecifyService;

    @Override
    public List<DuibaGuessAppSpecifyDto> findByDuibaGuessId(Long duibaGuessId) {
        return duibaGuessAppSpecifyService.findByDuibaGuessId(duibaGuessId);
    }

    @Override
    public void delete(Long id) {
        duibaGuessAppSpecifyService.delete(id);
    }

    @Override
    public DuibaGuessAppSpecifyDto insert(DuibaGuessAppSpecifyDto duibaGuessAppSpecify) {
        duibaGuessAppSpecifyService.insert(duibaGuessAppSpecify);
        return duibaGuessAppSpecify;
    }

    @Override
    public DuibaGuessAppSpecifyDto findByDuibaGuessAndApp(Long duibaGuessId, Long appId) {
        return duibaGuessAppSpecifyService.findByDuibaGuessAndApp(duibaGuessId, appId);
    }

    @Override
    public DuibaGuessAppSpecifyDto find(Long id) {
        return duibaGuessAppSpecifyService.find(id);
    }
}
