/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.service.impl
 * Date:2016年6月7日上午9:05:19
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;

/**
 * ClassName:ActivityCategoryServiceImpl <br/>
 * Date:     2016年6月7日 上午9:05:19 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("activityCategoryService")
public class ActivityCategoryServiceImpl implements ActivityCategoryService{
    @Autowired
    private ActivityCategoryDao activityCategoryDao;
    @Override
    public Long createCategory(String name, String content) {
        ActivityCategoryEntity e=new ActivityCategoryEntity();
        e.setName(name);
        e.setContent(content);
        activityCategoryDao.insert(e);
        return e.getId();
    }

    @Override
    public Boolean editCategoryContent(long id, String name, String content) {
        int ret=activityCategoryDao.updateCategoryContent(id, name, content);
        if(ret==1){
            return true;
        }
        return false;
    }

    @Override
    public Boolean enableCategory(long id) {
        int ret=activityCategoryDao.updateCategoryEnable(id);
        if(ret==1){
            return true;
        }
        return false;
    }

    @Override
    public Boolean disableCategory(long id) {
        int ret=activityCategoryDao.updateCategoryDisable(id);
        if(ret==1){
            return true;
        }
        return false;
    }

    @Override
    public List<ActivityCategoryEntity> findAll() {
        return activityCategoryDao.selectAll();
    }
    
    @Override
    public ActivityCategoryEntity findDefaultCategory() {
        List<ActivityCategoryEntity> list=findAll();
        for(ActivityCategoryEntity e:list){
            if(e.getDefaultCategory()==true){
                return e;
            }
        }
        return null;
    }

	@Override
	public ActivityCategoryEntity findById(long id) {
		return activityCategoryDao.select(id);
	}

}

