package cn.com.duiba.activity.center.biz.dao;

import cn.com.duiba.wolf.spring.datasource.AutoRoutingDataSource;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DelegatingDataSource;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.util.List;
import java.util.Map;

/**
 * 所有dao都需要继承此类,如果需要分表,请继承BaseShardDao
 */
public abstract class ActivityBaseDao {

    private static final Logger  log = LoggerFactory.getLogger(ActivityBaseDao.class);

    // @Resource(name = "consumerSqlSessionTemplate")
    // @Qualifier("newConsumerSqlSessionTemplate")
    // private SqlSessionTemplate consumerSqlSessionTemplate;

    @Resource(name = "creditsSqlSessionTemplate")
    private SqlSessionTemplate  creditsSqlSessionTemplate;
    @Resource(name="creditsActivitySqlSessionTemplate")
    private SqlSessionTemplate creditsActivitySqlSessionTemplate;

    @Resource(name = "creditsGameSqlSessionTemplate")
    private SqlSessionTemplate creditsGameSqlSessionTemplate;

    @Resource(name = "quizzSqlSessionTemplate")
    private SqlSessionTemplate   quizzSqlSessionTemplate;

    @Resource(name = "consumerQuizzSqlSessionTemplate")
    private SqlSessionTemplate   consumerQuizzSqlSessionTemplate;

    @Resource(name = "appQuizzSqlSessionTemplate")
    protected SqlSessionTemplate appQuizzSqlSessionTemplate;

     @Resource(name = "seckillAppSqlSessionTemplate")
     private SqlSessionTemplate seckillAppSqlSessionTemplate;

    // @Resource(name = "creditsActivitySqlSessionTemplate")
    // private SqlSessionTemplate creditsActivitySqlSessionTemplate;

    // @Resource(name = "managerSqlSessionTemplate")
    // private SqlSessionTemplate managerSqlSessionTemplate;

    @Resource(name = "ngameSqlSessionTemplate")
    private SqlSessionTemplate ngameSqlSessionTemplate;
    @Resource(name = "ngameAppSqlSessionTemplate")
    private SqlSessionTemplate ngameAppSqlSessionTemplate;
    @Resource(name = "ngameConSqlSessionTemplate")
    private SqlSessionTemplate ngameConSqlSessionTemplate;
    @Resource(name = "mngHdtoolSqlSessionTemplate")
    private SqlSessionTemplate mngHdtoolSqlSessionTemplate;
    @Resource(name = "appHdtoolSqlSessionTemplate")
    private SqlSessionTemplate appHdtoolSqlSessionTemplate;
    @Resource(name = "creditsHdtoolSqlSessionTemplate")
    private SqlSessionTemplate creditsHdtoolSqlSessionTemplate;

    @Resource(name = "guessSqlSessionTemplate")
    private SqlSessionTemplate guessSqlSessionTemplate;

    @Resource(name = "consumerGuessSqlSessionTemplate")
    private SqlSessionTemplate consumerGuessSqlSessionTemplate;

    @Resource(name = "appGuessSqlSessionTemplate")
    private SqlSessionTemplate appGuessSqlSessionTemplate;


    /**
     * 获取合适的sqlSessionTemplate
     *
     * @param isForceUseMasterDataSource
     * 是否强制使用master库,当为true时会强制使用master库,当为false时会判断当前是否正在事务中,如果是的话底层仍然会使用master库,如果不是的话会根据配置的规则按权重走主库或slave只读库.
     * 建议只在执行增删改sql时传入此参数为true.类似select * for update的语句实际上只在事务中有用,故如果不走事务,这样的语句有可能会被分配到只读库.所以写代码时需要注意for
     * update语句一定要放在事务中.
     * @return
     */
    private SqlSessionTemplate getSqlSessionTemplate(boolean isForceUseMasterDataSource) {
        DatabaseSchema databaseSchema = chooseSchema();
        if (databaseSchema == null) {
            throw new NullPointerException("please set databaseSchema in class:" + this.getClass().getName());
        }
        SqlSessionTemplate sqlSessionTemplate = null;
        switch (databaseSchema) {
            case CREDITS:
                sqlSessionTemplate = creditsSqlSessionTemplate;
                break;
            case NGAME:
                sqlSessionTemplate = ngameSqlSessionTemplate;
                break;
            case NGAME_APP:
                sqlSessionTemplate = ngameAppSqlSessionTemplate;
                break;
            case NGAME_CON:
                sqlSessionTemplate = ngameConSqlSessionTemplate;
                break;
             case SECKILL_APP:
             sqlSessionTemplate = seckillAppSqlSessionTemplate;
             break;
            case CREDITS_GAME:
                sqlSessionTemplate = creditsGameSqlSessionTemplate;
                break;
            case QUIZZ:
                sqlSessionTemplate = quizzSqlSessionTemplate;
                break;
            case QUIZZ_CONSUMER:
                sqlSessionTemplate = consumerQuizzSqlSessionTemplate;
                break;
            case QUIZZ_APP:
                sqlSessionTemplate = appQuizzSqlSessionTemplate;
                break;
            // case SECKILL:
            // sqlSessionTemplate = seckillSqlSessionTemplate;
            // break;
            case CREDITS_ACTIVITY:
                 sqlSessionTemplate = creditsActivitySqlSessionTemplate;
                 break;
            case MNG_HDTOOL:
                 sqlSessionTemplate = mngHdtoolSqlSessionTemplate;
                 break;
            case APP_HDTOOL:
                 sqlSessionTemplate = appHdtoolSqlSessionTemplate;
                 break;
            case CREDITS_HDTOOL:
                 sqlSessionTemplate = creditsHdtoolSqlSessionTemplate;
                 break;
            case GUESS:
                sqlSessionTemplate = guessSqlSessionTemplate;
                break;
            case GUESS_CON:
                sqlSessionTemplate = consumerGuessSqlSessionTemplate;
                break;
            case GUESS_APP:
                sqlSessionTemplate=appGuessSqlSessionTemplate;
                break;
            // case MANAGER:
            // sqlSessionTemplate = managerSqlSessionTemplate;
            // break;
            default:
                throw new NullPointerException("当你看到这个报错的时候,你肯定没有配置返回恰当的sqlSessionTemplate,麻烦屈身进来配置一下吧");
        }

        DataSource ds = sqlSessionTemplate.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource();
        // DataSource ds = sqlMapClientWithAutoRoutingDataSource.getDataSource();
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource) ds).getTargetDataSource();
        }

        if (ds instanceof AutoRoutingDataSource) {
            AutoRoutingDataSource autoRoutingDataSource = (AutoRoutingDataSource) ds;
            autoRoutingDataSource.determineCurrentLookupKeyByItSelf(isForceUseMasterDataSource);
        }

        return sqlSessionTemplate;
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    protected abstract DatabaseSchema chooseSchema();

    public int insert(String statement) {
        return getSqlSessionTemplate(true).insert(addNameSpace(statement));
    }

    public int delete(String statement) {
        return getSqlSessionTemplate(true).delete(addNameSpace(statement));
    }

    public int update(String statement) {
        return getSqlSessionTemplate(true).update(addNameSpace(statement));
    }

    public int delete(String statement, Object parameter) {
        return getSqlSessionTemplate(true).delete(addNameSpace(statement), parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return getSqlSessionTemplate(false).selectList(addNameSpace(statement), parameter, rowBounds);
    }

    public void select(String statement, ResultHandler handler) {
        getSqlSessionTemplate(false).select(addNameSpace(statement), handler);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return getSqlSessionTemplate(false).selectOne(addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return getSqlSessionTemplate(false).selectMap(addNameSpace(statement), parameter, mapKey);
    }

    public int insert(String statement, Object parameter) {
        return getSqlSessionTemplate(true).insert(addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return getSqlSessionTemplate(false).selectMap(addNameSpace(statement), parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        getSqlSessionTemplate(false).select(addNameSpace(statement), parameter, rowBounds, handler);
    }

    public <E> List<E> selectList(String statement) {
        return getSqlSessionTemplate(false).selectList(addNameSpace(statement));
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        getSqlSessionTemplate(false).select(addNameSpace(statement), parameter, handler);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return getSqlSessionTemplate(false).selectMap(addNameSpace(statement), mapKey);
    }

    public int update(String statement, Object parameter) {
        return getSqlSessionTemplate(true).update(addNameSpace(statement), parameter);
    }

    public <T> T selectOne(String statement) {
        return getSqlSessionTemplate(false).selectOne(addNameSpace(statement));
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return getSqlSessionTemplate(false).selectList(addNameSpace(statement), parameter);
    }

    /**
     * 获取mybatis命名空间
     *
     * @param method
     * @return
     */
    protected String addNameSpace(String method) {
        return getClass().getName() + "." + method;
    }

}
