package cn.com.duiba.activity.center.biz.dao.chaos.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.chaos.ActPreConsumerStockDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActPreConsumeStockEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yansen on 16/6/22.
 */
@Repository
public class ActPreConsumerStockDaoImpl extends ActivityBaseDao implements ActPreConsumerStockDao {
    @Override
    public void insert(ActPreConsumeStockEntity ActPreConsumeStockEntity) {
        insert("insert", ActPreConsumeStockEntity);
    }

    @Override
    public ActPreConsumeStockEntity findPreConsumerByBizPay(String bizId,
                                                            String bizSource) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("bizId", bizId);
        param.put("bizSource", bizSource);
        return selectOne("findPreConsumerByBizPay", param);
    }

    @Override
    public ActPreConsumeStockEntity findByLock(Long id) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("id", id);
        return selectOne("findByLock", param);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }
}
