package cn.com.duiba.activity.center.biz.dao.datasource;


public class DynamicDataSource {

	private static final ThreadLocal<Boolean> canGoReadWay = new ThreadLocal<Boolean>();

	static void markCanGoReadWay(){
		DynamicDataSource.canGoReadWay.set(true);
		ReadOnlyDataSource.setReadDataSource(ReadDataSource.getReadOnlyDateSource());
	}

	static void clearMark() {
		DynamicDataSource.canGoReadWay.remove();
		ReadOnlyDataSource.clearReadDataSource();
	}
	
	public static boolean canGoReadWay(){
		ReadOnlyDataSource.clearReadDataSource();
		Boolean can=canGoReadWay.get();
		if(can==null){
			return false;
		}
		ReadOnlyDataSource.setReadDataSource(ReadDataSource.getReadOnlyDateSource());
		return can.booleanValue();
	}

}
