package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameDao;
import cn.com.duiba.activity.center.biz.entity.ActivityExtraInfoEntity;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class DuibaNgameDaoImpl extends ActivityBaseDao implements DuibaNgameDao {

	@Override
	public List<DuibaNgameEntity> findByPage(Integer offset, Integer max, String title, Integer id) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("id", id);
		params.put("title", title);
		params.put("offset", offset);
		params.put("max", max);
		return selectList("findByPage", params);
	}
	
	@Override
	public Long findByPageCount(String title, Integer id) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("id", id);
		params.put("title", title);
		return selectOne("findByPageCount", params);
	}

	@Override
	public DuibaNgameEntity find(Long id) {
		return selectOne("find", id);
	}
	
	@Override
    public String findTagById(Long id) {
        return selectOne("findTagById", id);
    }

	@Override
	public void add(DuibaNgameEntity duibaNgameDO) {
		insert("add", duibaNgameDO);
	}

	@Override
	public void delete(Long id) {
		update("delete", id);
	}
	
	@Override
    public int updateTagById(Long id, String tag){
	    Map<String, Object> params = Maps.newHashMap();
        params.put("id", id);
        params.put("tag", tag);
        return update("updateTagById", params);
    }

	@Override
	public void update(DuibaNgameEntity duibaNgameDO) {
		update("update", duibaNgameDO);
	}

	@Override
	public int count() {
		return selectOne("count");
	}
	
	@Override
	public DuibaNgameEntity findOpenPrizeForUpdate(Long id) {
		return selectOne("findOpenPrizeForUpdate", id);
	}

	@Override
	public void updateSwitch(DuibaNgameEntity duibaNgameDO) {
		update("updateSwitch", duibaNgameDO);
	}

	@Override
	public List<DuibaNgameEntity> findAllByIds(List<Long> ids) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("ids", ids);
		return selectList("findAllByIds", params);
	}

	@Override
	public List<AddActivityEntity> findAllNgame(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllNgame", paramMap);
	}


	@Override
	public int updateOpenPrize(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateOpenPrize", paramMap);
	}

	@Override
	public List<DuibaNgameEntity> findAutoOff() {
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(new Date());
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();

		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", new Date());
		return selectList("findAutoOff", paramMap);
	}

	@Override
	public int updateStatus(Long id, Integer status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		return update("updateStatus", paramMap);
	}

	@Override
	public List<DuibaNgameEntity> findListByIds(List<Long> ids) {
		Map<String,Object> paramMap = Maps.newHashMap();
		paramMap.put("ids", ids);
		return selectList("findListByIds", paramMap);
	}

	@Override
	public ActivityExtraInfoEntity findExtraInfoById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findExtraInfoById", paramMap);
	}

	@Override
	public int updateActivityCategoryId(long id, Long activityCategoryId) {
	    Map<String, Object> params=new HashMap<String, Object>();
	    params.put("id", id);
	    params.put("activityCategoryId", activityCategoryId);
	    return update("updateActivityCategoryId", params);
	}
	
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
