/**
 * Project Name:activity-center-biz
 * File Name:ActivityPrizeOptionDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.prize.impl
 * Date:2016年7月26日下午3:56:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.prize.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.prize.ActivityPrizeOptionDao;

/**
 * ClassName:ActivityPrizeOptionDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午3:56:36 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class ActivityPrizeOptionDaoImpl extends ActivityBaseDao implements ActivityPrizeOptionDao{

    @Override
    public Long insert(ActivityPrizeOptionDto activityPrizeOptionDto) {
        insert("insert",activityPrizeOptionDto);
        return activityPrizeOptionDto.getId();
    }

    @Override
    public Long update(ActivityPrizeOptionDto activityPrizeOptionDto) {
        update("update", activityPrizeOptionDto);
        return activityPrizeOptionDto.getId();
    }

    @Override
    public Boolean delete(Long id) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", id);
        if(1== delete("del", map)){
            return true;
        }
        return false;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public List<ActivityPrizeOptionDto> selectActivityOptionsByConfigId(Long configId,String activityType) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("configId", configId);
        map.put("activityType", activityType);
        return selectList("selectActivityOptionsByConfigId",map);
    }

    @Override
    public ActivityPrizeOptionDto find(Long id) {
        Map<String,Object> param = Maps.newHashMap();
        param.put("id", id);
        return selectOne("find",param);
    }

}

