package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.*;

import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import cn.com.duiba.dcommons.enums.ExchangeStatusEnums;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;

@Repository
public class QuizzOrdersDaoImpl extends ActivityBaseDao implements QuizzOrdersDao {

    /**
     * 根据ID查询订单
     */
    public QuizzOrdersEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    public List<QuizzOrdersEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds", paramMap);
    }

    /**
     * 根据领取状态exchangeStatus查询小于endTime时间的订单
     */
    public List<Long> findExpireOrder() {
        Map<String, Object> paramMap = new HashMap<String, Object>(3);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.DATE, -1);
        Date endTime = cal.getTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(endTime);
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusWait.getStatus());
        return selectList("findExpireOrder", paramMap);
    }
    
    @Override
    public Integer insert(QuizzOrdersEntity quizzOrdersEntity){
    	return insert("insert", quizzOrdersEntity);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }

	
}
