package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import cn.com.duiba.activity.center.api.dto.ActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.AdvActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.asynctask.OperatingActivityAsyncTaskService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/14.
 */
@Service
public class RemoteOperatingActivityServiceNewImpl implements RemoteOperatingActivityServiceNew {
    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private OperatingActivityAsyncTaskService operatingActivityAsyncTaskService;
//    @Resource
//    private OperatingActivityBo operatingActivityBo;

    @Override
    public List<OperatingActivityDto> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type) {
        return operatingActivityService.findGameByAppIdAndActivityId(appId, duibaActivityIds, type);
    }

    @Override
    public List<OperatingActivityDto> findAllAppTasksContent(Long appId) {
        return operatingActivityService.findAllAppTasksContent(appId);
    }

    @Override
    public List<Long> findOpenLotteryIds() {
        return operatingActivityService.findOpenLotteryIds();
    }

    @Override
    public List<OperatingActivityDto> findAllOpenDuibaActivity(Long duibaActivityId) {
        return operatingActivityService.findAllOpenDuibaActivity(duibaActivityId);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaActivityIdAndDeleted(appId, duibaActivityId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaTurntableIdAndDeleted(appId, duibaTurntableId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndGameConfigDuibaIdAndDeleted(appId, gameConfigDuibaId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaSingleLotteryIdAndDeleted(appId, duibaSingleLotteryId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaQuestionAnswerIdAndDeleted(appId, duibaQuestionAnswerId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaSeckillIdAndDeleted(appId, duibaSeckillId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaHdtoolIdAndDeleted(appId, duibaHdtoolId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaQuizzIdAndDeleted(appId, duibaQuizzId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndAppSingleLotteryIdAndDeleted(appId, appSingleLotteryId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndAppManualLotteryAndDeleted(appId, appManualLotteryId, deleted);
    }

    @Override
    public Long countActivity(Map<String, Object> params) {
        return operatingActivityService.countActivity(params);
    }

    @Override
    public List<ActivityDto> findActivityList(Map<String, Object> params) {
        return operatingActivityService.findActivityList(params);
    }

    @Override
    public List<ActivityDto> findRecommendActivityList(Long appId) {
        return operatingActivityService.findRecommendActivityList(appId);
    }

    @Override
    public List<ActivityDto> findActivityListByParent(Map<String, Object> params) {
        return operatingActivityService.findActivityListByParent(params);
    }

    @Override
    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status) {
        return operatingActivityService.deleteTurntable(turntableId, appId, delete, status);
    }

    @Override
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId) {
        return operatingActivityService.findAppIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId) {
        return operatingActivityService.findAppIdsBySingleLotteryId(singleLotteryId);
    }

    @Override
    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type) {
        return operatingActivityService.findAppIdsByActivityIdAndType(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId) {
        return operatingActivityService.findAppIdsByDuibaSingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public Integer countAppByActivityIdAndType(Long activityId, Integer type) {
        return operatingActivityService.countAppByActivityIdAndType(activityId, type);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIds(List<Long> daIdList) {
        return operatingActivityService.findAllByDuibaActivityIds(daIdList);
    }

    @Override
    public List<OperatingActivityDto> findAllByActivityIdsAndType(List<Long> activityIds, Integer type) {
        return operatingActivityService.findAllByActivityIdsAndType(activityIds, type);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSingleLotteryIds(List<Long> dslIdList) {
        return operatingActivityService.findAllByDuibaSingleLotteryIds(dslIdList);
    }

    @Override
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId) {
        return operatingActivityService.findIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId) {
        return operatingActivityService.updateStatusByDuibaActivityId(status, duibaActivityId);
    }

    @Override
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId) {
        return operatingActivityService.updateStatusBySingleLotteryId(status, singleLotteryId);
    }

    @Override
    public int updateVisitTimes(Long id) {
        return operatingActivityService.updateVisitTimes(id);
    }

    @Override
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId) {
        return operatingActivityService.findIdsBySingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public List<OperatingActivityDto> findAllByType(Integer type) {
        return operatingActivityService.findAllByType(type);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryId(Long duibaSingleLotteryId) {
        return operatingActivityService.findAllBySingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted) {
        return operatingActivityService.findAllBySingleLotteryIdAndDeleted(duibaSingleLotteryId, deleted);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaSeckillIdAndDeleted(duibaSeckillId, deleted);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityId(Long duibaActivityId) {
        return operatingActivityService.findAllByDuibaActivityId(duibaActivityId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return operatingActivityService.findAllByDuibaSecondsKillId(duibaSecondsKillId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaActivityIdAndDeleted(duibaActivityId, deleted);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaQuestionAnswerIdAndDeleted(duibaQuestionAnswerId, deleted);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaQuizzIdAndDeleted(duibaQuizzId, deleted);
    }

    @Override
    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status) {
        operatingActivityService.updateStatusByActivityIdAndType(activityId, type, status);
    }

    @Override
    public OperatingActivityDto findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted) {
        return operatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(activityId, type, appId, deleted);
    }

    @Override
    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type) {
        return operatingActivityService.findIdsByDuibaActivityIdAndType(duibaActivityId, type);
    }

    @Override
    public List<OperatingActivityDto> findSingleLotteryOperaList(List<Long> activityIds, Long appId) {
        return operatingActivityService.findSingleLotteryOperaList(activityIds, appId);
    }

    @Override
    public OperatingActivityDto findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId) {
        return operatingActivityService.findByActivityIdAndParentIdAndTypeAndAppId(duibaActivityId, parentActivityId, type, appId);
    }

    @Override
    public void deleteByParentActivityIds(List<Long> parentIds) {
        operatingActivityService.deleteByParentActivityIds(parentIds);
    }

    @Override
    public OperatingActivityDto findOperatingSingleLottery(Long activityId, Long appId) {
        return operatingActivityService.findOperatingSingleLottery(activityId, appId);
    }

    @Override
    public List<OperatingActivityDto> findAllByIds(List<Long> ids) {
        return operatingActivityService.findAllByIds(ids);
    }

    @Override
    public int updateManualLotteryByIds(List<Long> ids) {
        return operatingActivityService.updateManualLotteryByIds(ids);
    }

    @Override
    public List<OperatingActivityDto> findAllEnabledActivies(Long appId) {
        return operatingActivityService.findAllEnabledActivies(appId);
    }

    @Override
    public List<OperatingActivityDto> findActiveActivity(Long appId) {
        return operatingActivityService.findActiveActivity(appId);
    }

    @Override
    public List<Long> findAllVirtualInTurntable(Long appId) {
        return operatingActivityService.findAllVirtualInTurntable(appId);
    }

    @Override
    public List<Long> findAllVirtualInSingleLottery(Long appId) {
        return operatingActivityService.findAllVirtualInSingleLottery(appId);
    }

    @Override
    public List<Long> findAllVirtualInHdTool(Long appId) {
        return operatingActivityService.findAllVirtualInHdTool(appId);
    }

    @Override
    public OperatingActivityDto find(Long id) {
        return operatingActivityService.find(id);
    }

    @Override
    public OperatingActivityDto insert(OperatingActivityDto operatingActivityDO) {
        operatingActivityService.insert(operatingActivityDO);
        return operatingActivityDO;
    }

    @Override
    public int update(OperatingActivityDto operatingActivityDO) {
        return operatingActivityService.update(operatingActivityDO);
    }

    @Override
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return operatingActivityService.findAppIdsByDuibaSecondsKillId(duibaSecondsKillId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
        return operatingActivityService.findAllByDuibaSecondsKillActivityId(duibaSecondsKillActivityId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return operatingActivityService.findAllByDuibaQuestionAnswerId(duibaQuestionAnswerId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzId(Long duibaQuizzId) {
        return operatingActivityService.findAllByDuibaQuizzId(duibaQuizzId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillId(Long duibaSeckillId) {
        return operatingActivityService.findAllByDuibaSeckillId(duibaSeckillId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaSecondsKillActivityIdAndDeleted(duibaSecondsKillActivityId, deleted);
    }

    @Override
    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId) {
        operatingActivityService.updateStatusByDuibaSecondsKillActivityId(status, duibaSecondsKillActivityId);
    }

    @Override
    public OperatingActivityDto findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType) {
        return operatingActivityService.findGameOperatingActivity(appId, gameConfigDuibaId, gameType);
    }

    @Override
    public OperatingActivityDto findQuestionAnswerOperatingActivity(Long appId, Long activityId) {
        return operatingActivityService.findQuestionAnswerOperatingActivity(appId, activityId);
    }

    @Override
    public OperatingActivityDto findSecondsKillOperatingActivity(Long appId, Long activityId) {
        return operatingActivityService.findSecondsKillOperatingActivity(appId, activityId);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaGameIdAndDeleted(appId, duibaGameId, deleted);
    }

    @Override
    public ActivityDto findByAppIdLimit(Long appId, Long activityId) {
        return operatingActivityService.findByAppIdLimit(appId, activityId);
    }

    @Override
    public List<OperatingActivityDto> findAllByAppId(Long appId) {
        return operatingActivityService.findAllByAppId(appId);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(appId, duibaSecondsKillActivityId, deleted);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return operatingActivityService.findDuibaQuestionAnswerByAppIdAndActivityId(appId, activityIds, type);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return operatingActivityService.findDuibaQuizzByAppIdAndActivityId(appId, activityIds, type);
    }

    @Override
    public List<OperatingActivityDto> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return operatingActivityService.findDuibaSeckillByAppIdAndActivityId(appId, activityIds, type);
    }

    @Override
    public List<ActivityDto> findOnlineActivity(Map<String, Object> params) {
        return operatingActivityService.findOnlineActivity(params);
    }

    @Override
    public List<ActivityDto> findOnlineActivityWithOutTopic(Map<String, Object> params) {
        return operatingActivityService.findOnlineActivityWithOutTopic(params);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted) {
        return operatingActivityService.findAllByDuibaGuessIdAndDeleted(duibaGuessId, deleted);
    }

    @Override
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId) {
        return operatingActivityService.findAppIdsByDuibaGuessId(duibaGuessId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaNgameId(Long duibaNgameId) {
        return operatingActivityService.findAllByDuibaNgameId(duibaNgameId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessId(Long duibaGuessId) {
        return operatingActivityService.findAllByDuibaGuessId(duibaGuessId);
    }

    @Override public List<OperatingActivityDto> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds,
                                                                                  Integer type) {
        return operatingActivityService.findDuibaNgameByAppIdAndActivityId(appId, activityIds, type);
    }

    @Override public List<OperatingActivityDto> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds,
                                                                                  Integer type) {
        return operatingActivityService.findDuibaGuessByAppIdAndActivityId(appId, activityIds, type);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaGuessIdAndDeleted(appId, duibaGuessId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaNgameActivityIdAndDeleted(appId, duibaNgameActivityId, deleted);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted) {
        return operatingActivityService.findByAppIdAndDuibaGuessActivityIdAndDeleted(appId, duibaGuessActivityId, deleted);
    }

    @Override
    public List<Long> findSeckillIdsByActivityId(Long duibaSeckillId) {
        return  operatingActivityService.findSeckillIdsByActivityId(duibaSeckillId);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return operatingActivityService.findAppIdsByIds(ids);
    }

    @Override
    public OperatingActivityDto insertUnique(OperatingActivityDto operatingActivityDO) {
        operatingActivityService.insert(operatingActivityDO);
        return operatingActivityDO;
    }
    
	@Override
	public DubboResult<Boolean> increaseJoinNum(Long operatingActivityId) {
		operatingActivityAsyncTaskService.increaseJoinNum(operatingActivityId);
		return DubboResult.successResult(true);
	}

    @Override
    public DubboResult<AdvActivityDto> queryAdvActivity(Long operatingActivityId) {
        OperatingActivityDto operatingActivity = operatingActivityService.find(operatingActivityId);
        if(null == operatingActivity){
            return DubboResult.failResult("活动不存在");
        }
        AdvActivityDto activity = new AdvActivityDto();
        activity.setOperatingActiivtyId(operatingActivityId);
        activity.setActivityId(operatingActivity.getActivityId());
        activity.setActivityType(operatingActivity.getType());
        activity.setOwer(operatingActivity.getActivityId()==null?"developer":"duiba");
        return DubboResult.successResult(activity);
    }

    @Override
    public DubboResult<List<OperatingActivityDto>> findByActivityId(Long activityId) {
        
        try {
            List<OperatingActivityDto> list = operatingActivityService.findByActivityId(activityId);
            return DubboResult.successResult(list);
        } catch (Exception e) {
           return DubboResult.failResult(e.getMessage());
        }
    }
}
