package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerBrickDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerBrickDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerBrickEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerBrickService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/6/2.
 */
@Service
public class DuibaQuestionAnswerBrickServiceImpl implements DuibaQuestionAnswerBrickService {
    @Resource
    private DuibaQuestionAnswerBrickDao duibaQuestionAnswerBrickDao;

    @Resource
    private CacheClient cacheClient;

    @Override
    public DuibaQuestionAnswerBrickDto find(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerBrickDao.find(id),DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public void insert(DuibaQuestionAnswerBrickDto duibaQuestionAnswerBrick) {
        DuibaQuestionAnswerBrickEntity e = BeanUtils.copy(duibaQuestionAnswerBrick, DuibaQuestionAnswerBrickEntity.class);
        duibaQuestionAnswerBrickDao.insert(e);
        duibaQuestionAnswerBrick.setId(e.getId());
    }

    @Override
    public void update4Admin(Long id, String title, String content, String md5) {
        duibaQuestionAnswerBrickDao.update4Admin(id, title, content, md5);
        cacheClient.remove(getNoContentCacheKey(id));
        cacheClient.remove(getContentCacheKey(id));
    }

    @Override
    public DuibaQuestionAnswerBrickDto findByTitle(String title) {
        return BeanUtils.copy(duibaQuestionAnswerBrickDao.findByTitle(title),DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public void open(Long id) {
        duibaQuestionAnswerBrickDao.open(id);
        cacheClient.remove(getNoContentCacheKey(id));
    }

    @Override
    public void disable(Long id) {
        duibaQuestionAnswerBrickDao.disable(id);
        cacheClient.remove(getNoContentCacheKey(id));
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaQuestionAnswerBrickDao.findPage(queryMap),DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return duibaQuestionAnswerBrickDao.findPageCount();
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findAll() {
        return BeanUtils.copyList(duibaQuestionAnswerBrickDao.findAll(),DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {
        return cacheClient.getWithCacheLoader(getContentCacheKey(id), 1, TimeUnit.HOURS, new CacheLoader<String>() {
            @Override
            public String load() {
                return duibaQuestionAnswerBrickDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKey(Long id){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_BRICK_NOCONTENT_BY_ID + id;
    }
    private String getContentCacheKey(Long id){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_BRICK_CONTENT_BY_ID + id;
    }

    @Override
    public DuibaQuestionAnswerBrickDto findNoContent(Long id) {
        String key = getNoContentCacheKey(id);
        DuibaQuestionAnswerBrickDto dto = cacheClient.get(key);
        if(dto == null){
            dto = BeanUtils.copy(duibaQuestionAnswerBrickDao.findNoContent(id),DuibaQuestionAnswerBrickDto.class);
            cacheClient.set(key, dto, 30, TimeUnit.MINUTES);
        }
        return dto;
    }
}
