package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/7.
 */
@Service
public class DuibaGuessServiceImpl implements DuibaGuessService {
    @Resource
    private DuibaGuessDao duibaGuessDao;

    @Override
    public DuibaGuessDto find(Long id) {
        return BeanUtils.copy(duibaGuessDao.find(id),DuibaGuessDto.class);
    }

    @Override
    public List<DuibaGuessDto> findByPage(Integer offset, Integer max, String title, Integer id) {
        return BeanUtils.copyList(duibaGuessDao.findByPage(offset, max, title, id),DuibaGuessDto.class);
    }

    @Override
    public Long findPageCount(String title, Integer id) {
        return duibaGuessDao.findPageCount(title, id);
    }

    @Override
    public int updateStatus(Long id, int status) {
        return duibaGuessDao.updateStatus(id, status);
    }

    @Override
    public int delete(Long id) {
        return duibaGuessDao.delete(id);
    }

    @Override
    public void insert(DuibaGuessDto duibaGuessDto) {
        DuibaGuessEntity entity=BeanUtils.copy(duibaGuessDto,DuibaGuessEntity.class);
        duibaGuessDao.insert(entity);
        duibaGuessDto.setId(entity.getId());
    }

    @Override
    public int updateInfoForm(DuibaGuessDto duibaGuessDto) {
        return duibaGuessDao.updateInfoForm(BeanUtils.copy(duibaGuessDto,DuibaGuessEntity.class));
    }

    @Override
    public int updateAutoOffDateNull(Date autoOffDate, Long id) {
        return duibaGuessDao.updateAutoOffDateNull(autoOffDate, id);
    }

    @Override
    public void updateSwitches(Long id, Integer switches) {
        duibaGuessDao.updateSwitches(id, switches);
    }

    @Override
    public void updateOpenWinning(Long id, String luckNum, Long rightSelectionId, Integer isAccurate) {
        duibaGuessDao.updateOpenWinning(id, luckNum, rightSelectionId, isAccurate);
    }

    @Override
    public List<DuibaGuessDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaGuessDao.findAllByIds(ids),DuibaGuessDto.class);
    }

    @Override
    public List<AddActivityDto> findAllGuess(Long appId) {
        return BeanUtils.copyList(duibaGuessDao.findAllGuess(appId),AddActivityDto.class);
    }

    @Override
    public List<DuibaGuessDto> findAutoOff() {
        return BeanUtils.copyList(duibaGuessDao.findAutoOff(),DuibaGuessDto.class);
    }

    @Override
    public int updateOpenPrize(Long id) {
        return duibaGuessDao.updateOpenPrize(id);
    }

}
