package cn.com.duiba.activity.center.biz.dao.activity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.entity.ActivityEntity;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;

import java.util.List;
import java.util.Map;

public interface OperatingActivityDao {

    public OperatingActivityEntity select(Long id);

    public List<OperatingActivityEntity> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type);

    /**
     * 获取能加到计划任务中的app活动
     */
    public List<OperatingActivityEntity> findAllAppTasksContent(Long appId);

    /**
     * 获取开启状态的抽奖活动ids
     */
    public List<Long> findOpenLotteryIds();

    /**
     * 获取所有添加了此兑吧专题活动的开启并且非删除状态的开发者活动
     */
    public List<OperatingActivityEntity> findAllOpenDuibaActivity(Long duibaActivityId);

    /**
     * @Title: findByAppIdAndDuibaActivityIdAndDeleted
     * @Description: 根据appId和duibaActivityId获取
     * @param appId
     * @param duibaActivityId
     * @return
     */
    public OperatingActivityEntity findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted);

    /**
     * 根据appId和duibaActivityId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted);

    /**
     * 根据appId和gameConfigDuibaId获取
     */
    public OperatingActivityEntity findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted);

    /**
     * 根据appId和duibaSingleLotteryId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted);

    /**
     * 根据appId和duibaQuestionAnswerId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted);

    /**
     * 根据appId和duibaSeckillId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted);

    /**
     * 根据appId和duibaHdtoolId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted);

    /**
     * 根据appId和duibaQuizzId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted);

    /**
     * 根据appId和AppSingleLotteryId获取
     */
    public OperatingActivityEntity findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted);

    public OperatingActivityEntity findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted);

    public Long countActivity(Map<String, Object> params);

    public List<ActivityEntity> findActivityList(Map<String, Object> params);

    public List<ActivityEntity> findRecommendActivityList(Long appId);


    public List<ActivityEntity> findActivityListByParent(Map<String, Object> params);

    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status);

    /**
     * @Title: findAppIdsByDuibaActivityId
     * @Description: 根据兑吧活动ID 获取所添加的AppId列表
     * @return
     */
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 根据单品抽奖ID获取APPID列表
     */
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId);

    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type);

    /**
     * 根据兑吧单品抽奖活动ID 获取所添加的AppId列表
     */
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId);

    public Integer countAppByActivityIdAndType(Long activityId, Integer type);

    /**
     * 根据兑吧活动ids获取List<OperatingActivityEntity>
     */
    public List<OperatingActivityEntity> findAllByDuibaActivityIds(List<Long> daIdList);

    public List<OperatingActivityEntity> findAllByActivityIdsAndType(List<Long> activityIds, Integer type);

    /**
     * 根据兑吧单品抽奖ids获取List<OperatingActivityEntity>
     */
    public List<OperatingActivityEntity> findAllByDuibaSingleLotteryIds(List<Long> dslIdList);

    /**
     * 根据兑吧活动id获取List<Long>
     */
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId);

    /**
     * 关闭所有已经添加该duibaActivity的活动
     */
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId);

    /**
     * 关闭所有已经添加该duibaSingleLottery的活动
     */
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId);

    public int updateVisitTimes(Long id);

    /**
     * 根据兑吧单品抽奖ID获取开发者活动ids
     */
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId);

    /**
     * 根据类型查询所有
     */
    public List<OperatingActivityEntity> findAllByType(Integer type);

    /**
     * 根据duibaSingleLotteryId查询
     */
    public List<OperatingActivityEntity> findAllBySingleLotteryId(Long duibaSingleLotteryId);

    public List<OperatingActivityEntity> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted);

    public List<OperatingActivityEntity> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted);

    public List<OperatingActivityEntity> findAllByDuibaActivityId(Long duibaActivityId);

    public List<OperatingActivityEntity> findAllByDuibaSecondsKillId(Long duibaSecondsKillId);

    public List<OperatingActivityEntity> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted);

    public List<OperatingActivityEntity> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted);

    public List<OperatingActivityEntity> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted);

    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status);

    public OperatingActivityEntity findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted);

    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type);

    public List<OperatingActivityEntity> findSingleLotteryOperaList(List<Long> activityIds, Long appId);

    /**
     * 用于查询子活动
     */
    public OperatingActivityEntity findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId);

    public void deleteByParentActivityIds(List<Long> parentIds);

    public OperatingActivityEntity findOperatingSingleLottery(Long activityId, Long appId);

    public List<OperatingActivityEntity> findAllByIds(List<Long> ids);

    public int updateManualLotteryByIds(List<Long> ids);

    /**
     * 查询某个App的所有正在启用状态的运营活动
     */
    public List<OperatingActivityEntity> findAllEnabledActivies(Long appId);

    /**
     * 获取开启状态的活动
     */
    public List<OperatingActivityEntity> findActiveActivity(Long appId);

    public List<Long> findAllVirtualInTurntable(Long appId);

    public List<Long> findAllVirtualInSingleLottery(Long appId);

    public List<Long> findAllVirtualInHdTool(Long appId);

    public OperatingActivityEntity find(Long id);

    public void insert(OperatingActivityEntity operatingActivityDO);

    public int update(OperatingActivityEntity operatingActivityDO);

    /**
     * 根据兑吧秒杀专题活动ID 获取所添加的AppId列表
     */
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId);

    public List<OperatingActivityEntity> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId);

    public List<OperatingActivityEntity> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId);

    public List<OperatingActivityEntity> findAllByDuibaQuizzId(Long duibaQuizzId);

    public List<OperatingActivityEntity> findAllByDuibaSeckillId(Long duibaSeckillId);

    public List<OperatingActivityEntity> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted);

    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId);

    public OperatingActivityEntity findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType);

    public OperatingActivityEntity findQuestionAnswerOperatingActivity(Long appId, Long activityId);

    public OperatingActivityEntity findSecondsKillOperatingActivity(Long appId, Long activityId);

    public OperatingActivityEntity findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted);

    public ActivityEntity findByAppIdLimit(Long appId, Long activityId);

    //from developer project
    public List<OperatingActivityEntity> findAllByAppId(Long appId);

    public OperatingActivityEntity findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted);

    public List<OperatingActivityEntity> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityEntity> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityEntity> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<ActivityEntity> findOnlineActivity(Map<String, Object> params);

    public List<ActivityEntity> findOnlineActivityWithOutTopic(Map<String, Object> params);

    public List<OperatingActivityEntity> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted);
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId);
    public List<OperatingActivityEntity> findAllByDuibaNgameId(Long duibaNgameId);
    public List<OperatingActivityEntity> findAllByDuibaGuessId(Long duibaGuessId);

    public List<OperatingActivityEntity> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);

    public List<OperatingActivityEntity> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type);


    /**
     * 根据appId和duibaQuizzId获取
     */
    public OperatingActivityEntity findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted);
    public OperatingActivityEntity findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted);
    public OperatingActivityEntity findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted);

    List<Long> findSeckillIdsByActivityId(Long duibaSeckillId);
	public List<Long> findAppIdsByIds(List<Long> ids);
    public List<Long> findIdsByParentIdsAndType(List<Long> parentIds,int type);
    
    public void insertUnique(OperatingActivityEntity operatingActivityEntity);
    
    public int updateWin(Long operatingActivityId, Integer offset);
}
