package cn.com.duiba.activity.center.biz.dao.activity.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.entity.ActivityEntity;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;

import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class OperatingActivityDaoImpl extends ActivityBaseDao implements OperatingActivityDao {

    @Override
    public OperatingActivityEntity select(Long id) {
        return selectOne("select", id);
    }

    @Override
    public List<OperatingActivityEntity> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type) {
        if(duibaActivityIds==null || duibaActivityIds.size()<1){
            return new ArrayList<>();
        }
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaActivityIds", duibaActivityIds);
        queryMap.put("type", type);
        return selectList("findGameByAppIdAndActivityId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllAppTasksContent(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllAppTasksContent", queryMap);
    }

    @Override
    public List<Long> findOpenLotteryIds() {
        return selectList("findOpenLotteryIds");
    }

    @Override
    public List<OperatingActivityEntity> findAllOpenDuibaActivity(Long duibaActivityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        return selectList("findAllOpenDuibaActivity", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaActivityId", duibaActivityId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaActivityIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaTurntableId", duibaTurntableId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaTurntableIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaSingleLotteryIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("appSingleLotteryId", appSingleLotteryId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndAppSingleLotteryIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("appManualLotteryId", appManualLotteryId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndAppManualLotteryAndDeleted", queryMap);
    }

    @Override
    public Long countActivity(Map<String, Object> params) {
        return selectOne("countActivity", params);
    }

    @Override
    public List<ActivityEntity> findActivityList(Map<String, Object> params) {
        return selectList("findActivityList", params);
    }

    @Override
    public List<ActivityEntity> findRecommendActivityList(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findRecommendActivityList", queryMap);
    }

    @Override
    public List<ActivityEntity> findActivityListByParent(Map<String, Object> params) {
        return selectList("findActivityListByParent", params);
    }

    @Override
    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("turntableId", turntableId);
        queryMap.put("appId", appId);
        queryMap.put("delete", delete);
        queryMap.put("status", status);
        return update("deleteTurntable", queryMap);
    }

    @Override
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        return selectList("findAppIdsByDuibaActivityId", queryMap);
    }

    @Override
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("singleLotteryId", singleLotteryId);
        return selectList("findAppIdsBySingleLotteryId", queryMap);
    }

    @Override
    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityId", activityId);
        queryMap.put("type", type);
        return selectList("findAppIdsByActivityIdAndType", queryMap);
    }

    @Override
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        return selectList("findAppIdsByDuibaSingleLotteryId", queryMap);
    }

    @Override
    public Integer countAppByActivityIdAndType(Long activityId, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityId", activityId);
        queryMap.put("type", type);
        return selectOne("countAppByActivityIdAndType", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaActivityIds(List<Long> daIdList) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("daIdList", daIdList);
        return selectList("findAllByDuibaActivityIds", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByActivityIdsAndType(List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findAllByActivityIdsAndType", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSingleLotteryIds(List<Long> dslIdList) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("dslIdList", dslIdList);
        return selectList("findAllByDuibaSingleLotteryIds", queryMap);
    }

    @Override
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        return selectList("findIdsByDuibaActivityId", queryMap);
    }

    @Override
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("status", status);
        queryMap.put("duibaActivityId", duibaActivityId);
        return update("updateStatusByDuibaActivityId", queryMap);
    }

    @Override
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("status", status);
        queryMap.put("singleLotteryId", singleLotteryId);
        return update("updateStatusBySingleLotteryId", queryMap);
    }

    @Override
    public int updateVisitTimes(Long id) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("id", id);
        return update("updateVisitTimes", queryMap);
    }

    @Override
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        return selectList("findIdsBySingleLotteryId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByType(Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("type", type);
        return selectList("findAllByType", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllBySingleLotteryId(Long duibaSingleLotteryId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        return selectList("findAllBySingleLotteryId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        queryMap.put("deleted", deleted);
        return selectList("findAllBySingleLotteryIdAndDeleted", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaActivityId(Long duibaActivityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        return selectList("findAllByDuibaActivityId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSecondsKillId(Long duibaSecondsKillId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaSecondsKillId", duibaSecondsKillId);
        return selectList("findAllByDuibaSecondsKillId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        queryMap.put("deleted", deleted);
        return selectList("findAllByDuibaActivityIdAndDeleted", queryMap);
    }

    @Override
    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityId", activityId);
        queryMap.put("type", type);
        queryMap.put("status", status);
        update("updateStatusByActivityIdAndType", queryMap);
    }

    @Override
    public OperatingActivityEntity findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityId", activityId);
        queryMap.put("type", type);
        queryMap.put("appId", appId);
        queryMap.put("deleted", deleted);
        return selectOne("findByActivityIdAndTypeAndAppIdAndDeleted", queryMap);
    }

    @Override
    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        queryMap.put("type", type);
        return selectList("findIdsByDuibaActivityIdAndType", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findSingleLotteryOperaList(List<Long> activityIds, Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("ids", activityIds);
        queryMap.put("appId", appId);
        return selectList("findSingleLotteryOperaList", queryMap);
    }

    @Override
    public OperatingActivityEntity findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("duibaActivityId", duibaActivityId);
        queryMap.put("parentActivityId", parentActivityId);
        queryMap.put("type", type);
        queryMap.put("appId", appId);
        return selectOne("findByActivityIdAndParentIdAndTypeAndAppId", queryMap);
    }

    @Override
    public void deleteByParentActivityIds(List<Long> parentIds) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("parentIds", parentIds);
        update("deleteByParentActivityIds", queryMap);
    }

    @Override
    public OperatingActivityEntity findOperatingSingleLottery(Long activityId, Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("activityId", activityId);
        queryMap.put("appId", appId);
        return selectOne("findOperatingSingleLottery", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByIds(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return Collections.emptyList();
        }
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("ids", ids);
        return selectList("findAllByIds", queryMap);
    }

    @Override
    public int updateManualLotteryByIds(List<Long> ids) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("ids", ids);
        return update("updateManualLotteryByIds", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllEnabledActivies(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllEnabledActivies", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findActiveActivity(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findActiveActivity", queryMap);
    }

    @Override
    public List<Long> findAllVirtualInTurntable(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllVirtualInTurntable", queryMap);
    }

    @Override
    public List<Long> findAllVirtualInSingleLottery(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllVirtualInSingleLottery", queryMap);
    }

    @Override
    public List<Long> findAllVirtualInHdTool(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllVirtualInHdTool", queryMap);
    }

    @Override
    public OperatingActivityEntity find(Long id) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("id", id);
        return selectOne("find", queryMap);
    }

    @Override
    public void insert(OperatingActivityEntity operatingActivityEntity) {
        insert("insert", operatingActivityEntity);
    }

    @Override
    public int update(OperatingActivityEntity operatingActivityEntity) {
        return update("update", operatingActivityEntity);
    }

    @Override
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
        return this.selectList("findAppIdsByDuibaSecondsKillId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
        return this.selectList("findAllByDuibaSecondsKillActivityId", paramMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaHdtoolId", duibaHdtoolId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaHdtoolIdAndDeleted", queryMap);
    }

    @Override
    public ActivityEntity findByAppIdLimit(Long appId, Long activityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("status", OperatingActivityDto.StatusIntOpen);
        queryMap.put("activityId", activityId);
        return selectOne("findByAppIdLimit", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("gameConfigDuibaId", gameConfigDuibaId);
        paramMap.put("deleted", deleted);
        return this.selectOne("findByAppIdAndGameConfigDuibaIdAndDeleted", paramMap);
    }

    @Override
    public OperatingActivityEntity findGameOperatingActivity(Long appId, Long gameConfigDuibaId,Integer gameType) {
        if(!OperatingActivityDto.GAME_TYPES.contains(gameType)){
            throw new RuntimeException("传入类型非游戏类型");
        }
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("gameConfigDuibaId", gameConfigDuibaId);
        paramMap.put("gameType", gameType);
        return this.selectOne("findGameOperatingActivity", paramMap);
    }
    @Override
    public OperatingActivityEntity findQuestionAnswerOperatingActivity(Long appId,Long activityId){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("activityId", activityId);
        return this.selectOne("findQuestionAnswerOperatingActivity", paramMap);
    }

    @Override
    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", status);
        paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
        this.update("updateStatusByDuibaSecondsKillActivityId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
        paramMap.put("deleted", deleted);
        return this.selectList("findAllByDuibaSecondsKillActivityIdAndDeleted", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaQuestionAnswerId", duibaQuestionAnswerId);
        paramMap.put("deleted", deleted);
        return this.selectList("findAllByDuibaQuestionAnswerIdAndDeleted", paramMap);

    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaQuizzId", duibaQuizzId);
        paramMap.put("deleted", deleted);
        return this.selectList("findAllByDuibaQuizzIdAndDeleted", paramMap);

    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaQuestionAnswerId", duibaQuestionAnswerId);
        return this.selectList("findAllByDuibaQuestionAnswerId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaQuizzId(Long duibaQuizzId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaQuizzId", duibaQuizzId);
        return this.selectList("findAllByDuibaQuizzId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSeckillId(Long duibaSeckillId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSeckillId", duibaSeckillId);
        return this.selectList("findAllByDuibaSeckillId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSeckillId", duibaSeckillId);
        paramMap.put("deleted", deleted);
        return this.selectList("findAllByDuibaSeckillIdAndDeleted", paramMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaQuestionAnswerId", duibaQuestionAnswerId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaQuestionAnswerIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaSeckillId", duibaSeckillId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaSeckillIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findSecondsKillOperatingActivity(Long appId,Long activityId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityId", activityId);
        return selectOne("findSecondsKillOperatingActivity", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaQuizzId", duibaQuizzId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaQuizzIdAndDeleted", queryMap);
    }

    public OperatingActivityEntity findByAppIdAndDuibaGameIdAndDeleted(Long appId,
                                                                   Long duibaGameId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaGameId", duibaGameId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaGameIdAndDeleted", queryMap);
    }




    @Override
    public List<OperatingActivityEntity> findAllByAppId(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return selectList("findAllByAppId", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
        paramMap.put("deleted", deleted);
        return this.selectOne("findByAppIdAndDuibaSecondsKillActivityIdAndDeleted", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findDuibaQuestionAnswerByAppIdAndActivityId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findDuibaSeckillByAppIdAndActivityId", queryMap);
    }

    @Override
    public List<ActivityEntity> findOnlineActivity(Map<String, Object> params) {
        return selectList("findOnlineActivity", params);
    }

    @Override
    public List<ActivityEntity> findOnlineActivityWithOutTopic(Map<String, Object> params) {
        return selectList("findOnlineActivityWithOutTopic", params);
    }

    @Override
    public List<OperatingActivityEntity> findDuibaQuizzByAppIdAndActivityId(
            Long appId, List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findDuibaQuizzByAppIdAndActivityId", queryMap);
    }

    @Override
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        return selectList("findAppIdsByDuibaGuessId", paramMap);
    }
    @Override
    public List<OperatingActivityEntity> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("deleted", deleted);
        return selectList("findAllByDuibaGuessIdAndDeleted", paramMap);

    }
    @Override
    public List<OperatingActivityEntity> findAllByDuibaGuessId(Long duibaGuessId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaGuessId", duibaGuessId);
        return selectList("findAllByDuibaGuessId", paramMap);
    }
    @Override
    public List<OperatingActivityEntity> findAllByDuibaNgameId(Long duibaNgameId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaNgameId", duibaNgameId);
        return selectList("findAllByDuibaNgameId", paramMap);
    }

    @Override
    public List<OperatingActivityEntity> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findDuibaNgameByAppIdAndActivityId", queryMap);
    }

    @Override
    public List<OperatingActivityEntity> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("activityIds", activityIds);
        queryMap.put("type", type);
        return selectList("findDuibaGuessByAppIdAndActivityId", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("duibaGuessId", duibaGuessId);
        queryMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaGuessIdAndDeleted", queryMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaNgameActivityIdAndDeleted(
            Long appId, Long duibaNgameActivityId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("duibaNgameActivityId", duibaNgameActivityId);
        paramMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaNgameActivityIdAndDeleted", paramMap);
    }

    @Override
    public OperatingActivityEntity findByAppIdAndDuibaGuessActivityIdAndDeleted(
            Long appId, Long duibaGuessActivityId, Boolean deleted) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("duibaGuessActivityId", duibaGuessActivityId);
        paramMap.put("deleted", deleted);
        return selectOne("findByAppIdAndDuibaGuessActivityIdAndDeleted", paramMap);
    }

    @Override
    public List<Long> findSeckillIdsByActivityId(Long duibaSeckillId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSeckillId", duibaSeckillId);
        return selectList("findSeckillIdsByActivityId", paramMap);
    }
	
	@Override
	public List<Long> findAppIdsByIds(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return Collections.emptyList();
        }
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAppIdsByIds", paramMap);
	}

    public List<Long> findIdsByParentIdsAndType(List<Long> parentIds,int type){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("parentIds", parentIds);
        paramMap.put("type", type);
        return selectList("findIdsByParentIdsAndType", paramMap);
    }
    @Override
    public void insertUnique(OperatingActivityEntity operatingActivityEntity) {
        insert("insertUnique", operatingActivityEntity);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }

	@Override
	public int updateWin(Long operatingActivityId, Integer offset) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("id", operatingActivityId);
		map.put("offset", offset);
        return update("updateWin", map);
	}

}
