package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerBrickDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerBrickEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionAnswerBrickDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerBrickDao {

	@Override
	public DuibaQuestionAnswerBrickEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public void insert(DuibaQuestionAnswerBrickEntity duibaQuestionAnswerBrick) {
		insert("insert", duibaQuestionAnswerBrick);
	}

	@Override
	public void update4Admin(Long id, String title, String content, String md5) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("title", title);
		paramMap.put("content", content);
		paramMap.put("md5", md5);
		update("update4Admin", paramMap);

	}

	@Override
	public DuibaQuestionAnswerBrickEntity findByTitle(String title) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("title", title);
		return selectOne("findByTitle", paramMap);
	}

	@Override
	public void open(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("open", paramMap);
	}

	@Override
	public void disable(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("disable", paramMap);
	}

	@Override
	public List<DuibaQuestionAnswerBrickEntity> findPage(Map<String, Object> paramMap) {
		return selectList("findPage", paramMap);
	}

	@Override
	public Long findPageCount() {
		return selectOne("findPageCount");
	}

	@Override
	public List<DuibaQuestionAnswerBrickEntity> findAll() {
		return selectList("findAll");
	}

	@Override
	public String getBrickContentById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("getBrickContentById", paramMap);
	}

	@Override
	public DuibaQuestionAnswerBrickEntity findNoContent(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findNoContent", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
