package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionStockManualChangeEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionStockManualChangeDaoImpl extends ActivityBaseDao implements DuibaQuestionStockManualChangeDao {

	@Override
	public List<DuibaQuestionStockManualChangeEntity> findByStockId(Long gameStockId) {
		return selectList("findByStockId", gameStockId);
	}

	@Override
	public void addBatch(List<DuibaQuestionStockManualChangeEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	public void add(DuibaQuestionStockManualChangeEntity questionStockManualChangeDO) {
		insert("add", questionStockManualChangeDO);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
