package cn.com.duiba.activity.center.biz.kafka;

import org.apache.kafka.clients.producer.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.utils.UUIDUtils;

import javax.annotation.PostConstruct;

import java.util.Properties;

@Component
public class KafkaClient {

    private Producer<String, String> producer                    = null;

    @Value("${activity.kafka.bootstrap.servers}")
    private String                   bootstrapServers;

    public String getBootstrapServers() {
        return bootstrapServers;
    }

    public Producer<String, String> getProducer() {
        return producer;
    }

    public String sendMsg(String queueName, String body) throws Exception {
        String id = UUIDUtils.createUUID();
        //final Future<RecordMetadata> future =
        producer.send(new ProducerRecord<String, String>(queueName, id, body), new Callback() {

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            }
        });
        //producer.flush();
        //future.get();
        return id;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        // The number of acknowledgments the producer requires the leader to have received before considering a request
        // complete. This controls the durability of records that are sent. The following settings are common:
        props.put("acks", "all");
        props.put("retries", 3);
        props.put("batch.size", 16384);// in bytes//16384
        props.put("linger.ms", 0);
        // The configuration controls the maximum amount of time the client will wait for the response of a request. If
        // the response is not received before the timeout elapses the client will resend the request if necessary or
        // fail the request if retries are exhausted.
        props.put("request.timeout.ms", 30000);
        // The first time data is sent to a topic we must fetch metadata about that topic to know which servers host the
        // topic's partitions. This fetch to succeed before throwing an exception back to the client.
        props.put("metadata.fetch.timeout.ms", 10000);
        // props.put("timeout.ms", 60000);
        props.put("buffer.memory", 33554432);// 33554432
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");

        producer = new KafkaProducer<String, String>(props);
    }
}
