package cn.com.duiba.activity.center.biz.plugin.event.order;

import cn.com.duiba.activity.center.biz.plugin.event.DuibaEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

public class ActivityOrdersEvent implements DuibaEvent<ActivityOrderDto> {

	public enum ActivityOrdersEventType {
		OnOrderCreate, 
		OnOrderSuccess, 
		OnOrderFail
	}

	private ActivityOrderDto order;
	private ActivityOrdersEventType type;

	public ActivityOrdersEvent(ActivityOrdersEventType type, ActivityOrderDto order) {
		this.type = type;
		this.order = order;
	}

	@Override
	public ActivityOrderDto getData(){
		return order;
	}

	public ActivityOrdersEventType getType() {
		return type;
	}

	public interface ActivityOrdersEventListener {
		/**
		 * 创建订单
		 * 
		 * @param order
		 */
		public void onOrderCreate(ActivityOrderDto order);

		/**
		 * 订单成功
		 * 
		 * @param order
		 */
		public void onOrderSuccess(ActivityOrderDto order);

		/**
		 * 订单失败
		 * 
		 * @param order
		 */
		public void onOrderFail(ActivityOrderDto order);
	}

}
