package cn.com.duiba.activity.center.biz.remoteservice.impl.direct;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteActivityBlackList4DeveloperService;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.kafka.common.metrics.stats.Count;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by suyuanlong on 16/7/18.
 */
@Service
public class RemoteActivityBlackList4DeveloperServiceImpl implements RemoteActivityBlackList4DeveloperService {

    @Autowired
    private DeveloperActBlackService developerActBlackService;

    @Override
    public DubboResult<Boolean> isExistBlackByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType, Long developerId) {


        ActivityBlackList4DeveloperDto dto = new ActivityBlackList4DeveloperDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setDeveloperId(developerId);
        Integer result = developerActBlackService.query(dto);
        Boolean bolresult = false;
        if (result > 0) {
            bolresult = true;
        }
        developerActBlackService.setBlackCache(dto, bolresult);
        return DubboResult.successResult(bolresult);
    }


    @Override
    public DubboResult<ActivityBlackList4DeveloperDto> insertBlack4Developer(ActivityBlackList4DeveloperDto blackList4DeveloperDto) {
        ActivityBlackList4DeveloperDto dto = developerActBlackService.insertActivityBalack(blackList4DeveloperDto);

        if (null != dto) {
            return DubboResult.successResult(dto);
        } else {
            return DubboResult.successResult(null);
        }
    }

    @Override
    public DubboResult<List<ActivityBlackList4DeveloperDto>> insertBlackList4Developer(List<ActivityBlackList4DeveloperDto> btos) {
        List<ActivityBlackList4DeveloperDto> dtos = this.developerActBlackService.createBlackList(btos);
        if (null != dtos && dtos.size() > 0) {
            return DubboResult.successResult(btos);
        }
        return DubboResult.successResult(null);

    }

    @Override
    public DubboResult<Boolean> deleteBlackById(Long id) {
        boolean ret = this.developerActBlackService.removeBlack(id);

        return DubboResult.successResult(ret);
    }



    @Override
    public DubboResult<List<ActivityBlackList4DeveloperDto>> findByActivityIdAndActivityType(Long activityId, Integer activityType, Integer offset, Integer limit) {

        List<ActivityBlackList4DeveloperDto> dtos = this.developerActBlackService.queryByActivity(activityId, activityType, offset, limit);
        if (null != dtos && dtos.size() > 0) {
            return DubboResult.successResult(dtos);
        } else {
           return  DubboResult.successResult(null);
        }
    }



    @Override
    public DubboResult<Integer> findCountByActivityIdAndActivityType(Long activityId, Integer activityType) {
       int count=this.developerActBlackService.queryCountByActivity(activityId,activityType);
        return DubboResult.successResult(count);
    }


}
