package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionRecordDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionRecordService;
import cn.com.duiba.activity.center.biz.bo.game.DuibaQuestionRecordBo;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionRecordService;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class RemoteDuibaQuestionRecordServiceImpl implements RemoteDuibaQuestionRecordService {
    @Resource
    private DuibaQuestionRecordService duibaQuestionRecordService;
    @Resource
    private DuibaQuestionRecordBo duibaQuestionRecordBo;

    @Override
    public List<DuibaQuestionRecordDto> findByBankIdAndLimit(Long qBankId, Integer limit) {
        return duibaQuestionRecordService.findByBankIdAndLimit(qBankId, limit);
    }

    @Override
    public Long findCountByBankIdsStr(List<String> bankIds) {
        return duibaQuestionRecordService.findCountByBankIdsStr(bankIds);
    }

    @Override
    public DuibaQuestionRecordDto findById(Long id) {
        return duibaQuestionRecordService.findById(id);
    }

    @Override
    public Long findTotalCount(Long questionBankId) {
        return duibaQuestionRecordService.findTotalCount(questionBankId);
    }

    @Override
    public DuibaQuestionRecordDto insert_manager(DuibaQuestionRecordDto questionRecordDO) throws BusinessException {
        duibaQuestionRecordBo.insert_manager(questionRecordDO);
        return questionRecordDO;
    }

    @Override
    public PaginationDto<DuibaQuestionRecordDto> findByPage_manager(Long questionBankId, Integer offset, Integer max) {
        return duibaQuestionRecordBo.findByPage_manager(questionBankId, offset, max);
    }

    @Override
    public void delete_manager(Long id) throws BusinessException {
        duibaQuestionRecordBo.delete_manager(id);
    }
}
