package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteDuibaNgameAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameAppSpecifyService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/14.
 */
@Service
public class RemoteDuibaNgameAppSpecifyServiceImpl implements RemoteDuibaNgameAppSpecifyService {
    @Resource
    private DuibaNgameAppSpecifyService duibaNgameAppSpecifyService;

    @Override
    public List<DuibaNgameAppSpecifyDto> findByGameId(Long id) {
        return duibaNgameAppSpecifyService.findByGameId(id);
    }

    @Override
    public void delete(Long id) {
        duibaNgameAppSpecifyService.delete(id);
    }

    @Override
    public void addBatch(List<DuibaNgameAppSpecifyDto> list) {
        duibaNgameAppSpecifyService.addBatch(list);
    }

    @Override
    public DuibaNgameAppSpecifyDto add(DuibaNgameAppSpecifyDto gameAppSpecifyDO) {
        duibaNgameAppSpecifyService.add(gameAppSpecifyDO);
        return gameAppSpecifyDO;
    }

    @Override
    public DuibaNgameAppSpecifyDto findByGameConfigAndAppId(Long appId, Long duibaGameId) {
        return duibaNgameAppSpecifyService.findByGameConfigAndAppId(appId, duibaGameId);
    }

    @Override
    public Map<Long, DuibaNgameAppSpecifyDto> findByGameConfigAndAppId(Long appId, List<Long> duibaGameIds) {
        return duibaNgameAppSpecifyService.findByGameConfigsAndAppId(appId, duibaGameIds);
    }

}
