package cn.com.duiba.activity.center.biz.service.game.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionRecordDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionRecordDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionRecordEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionRecordService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionRecordServiceImpl implements DuibaQuestionRecordService {
    @Resource
    private DuibaQuestionRecordDao duibaQuestionRecordDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByBankId(Long bankId){
        return CacheConstants.KEY_DUIBA_QUESTION_RECORD_BY_QBANKID + bankId;
    }

    @Override
    public List<DuibaQuestionRecordDto> findByBankIdAndLimit(Long qBankId, Integer limit) {
        String key = getCacheKeyByBankId(qBankId);
        List<DuibaQuestionRecordDto> list = cacheClient.get(key);
        if(list == null){
            list = BeanUtils.copyList(duibaQuestionRecordDao.findByBankIdAndLimit(qBankId, limit), DuibaQuestionRecordDto.class);
            cacheClient.set(key, list, 20, TimeUnit.MINUTES);
        }
        return list;
    }

    @Override
    public void insert(DuibaQuestionRecordDto questionRecordDO) {
        DuibaQuestionRecordEntity e = BeanUtils.copy(questionRecordDO, DuibaQuestionRecordEntity.class);
        duibaQuestionRecordDao.insert(e);
        questionRecordDO.setId(e.getId());
        cacheClient.remove(getCacheKeyByBankId(questionRecordDO.getBankId()));
    }

    @Override
    public List<DuibaQuestionRecordDto> findByPage(Long questionBankId, Integer offset, Integer max) {
        return BeanUtils.copyList(duibaQuestionRecordDao.findByPage(questionBankId, offset, max), DuibaQuestionRecordDto.class);
    }

    @Override
    public Long findCountByBankIdsStr(List<String> bankIds) {
        return duibaQuestionRecordDao.findCountByBankIdsStr(bankIds);
    }

    @Override
    public DuibaQuestionRecordDto findById(Long id) {
        return BeanUtils.copy(duibaQuestionRecordDao.findById(id), DuibaQuestionRecordDto.class);
    }

    @Override
    public Long findTotalCount(Long questionBankId) {
        return duibaQuestionRecordDao.findTotalCount(questionBankId);
    }

    @Override
    public int delete(Long id) {
        DuibaQuestionRecordEntity e = duibaQuestionRecordDao.findById(id);
        int ret = 0;
        if(e != null) {
            ret = duibaQuestionRecordDao.delete(id);
            cacheClient.remove(getCacheKeyByBankId(e.getBankId()));
        }
        return ret;
    }
}
