package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessStockDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessStockDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessStockEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class DuibaGuessStockServiceImpl implements DuibaGuessStockService {

    @Autowired
    private DuibaGuessStockDao duibaGuessStockDao;

    @Override
    public DuibaGuessStockDto findRemaining(Long relationId) {
        return BeanUtils.copy(duibaGuessStockDao.findRemaining(relationId),DuibaGuessStockDto.class);
    }

    @Override
    public int subStock(Long id, Integer subNumber) {
        return duibaGuessStockDao.subStock(id,subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return duibaGuessStockDao.addStock(id,addNumber);
    }

    @Override
    public DuibaGuessStockDto findByGuessOptionId(Long guessOptionId) {
        return BeanUtils.copy(duibaGuessStockDao.findByGuessOptionId(guessOptionId),DuibaGuessStockDto.class);
    }

    @Override
    public List<DuibaGuessStockDto> findByGuessOptionIds(List<Long> list) {
        return BeanUtils.copyList(duibaGuessStockDao.findByGuessOptionIds(list),DuibaGuessStockDto.class);
    }

    /**
     * 增加库存
     *
     * @param id
     * @param stockAdd
     * @return
     */
    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        return duibaGuessStockDao.updateStockAdd(id,stockAdd);
    }

    /**
     * 减少库存
     *
     * @param id
     * @param stockSub
     * @return
     */
    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        return duibaGuessStockDao.updateStockSub(id,stockSub);
    }

    @Override
    public void add(DuibaGuessStockDto guessStockDO) {
        DuibaGuessStockEntity entity=BeanUtils.copy(guessStockDO,DuibaGuessStockEntity.class);
        duibaGuessStockDao.add(entity);
        guessStockDO.setId(entity.getId());
    }

    @Override
    public List<DuibaGuessStockDto> addBatch(List<DuibaGuessStockDto> list) {
    	List<DuibaGuessStockEntity> listEntity = BeanUtils.copyList(list,DuibaGuessStockEntity.class);
        duibaGuessStockDao.addBatch(listEntity);
        return BeanUtils.copyList(listEntity,DuibaGuessStockDto.class);
    }
}
