/**
 * Project Name:activity-center-biz
 * File Name:ActivityPrizeOptionServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.service.prize.impl
 * Date:2016年7月26日下午4:03:00
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.prize.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.dao.prize.ActivityPrizeOptionDao;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;

/**
 * ClassName:ActivityPrizeOptionServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午4:03:00 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ActivityPrizeOptionServiceImpl implements ActivityPrizeOptionService{
    
    @Autowired
    private ActivityPrizeOptionDao activityPrizeOptionDao;

    @Override
    public Long saveOrUpdateOption(ActivityPrizeOptionDto activityPrizeOptionDto) {
        if(null != activityPrizeOptionDto.getId()){
            return activityPrizeOptionDao.update(activityPrizeOptionDto);
        }
        return activityPrizeOptionDao.insert(activityPrizeOptionDto);
    }

    @Override
    public Boolean deleteOption(Long id) {
        return activityPrizeOptionDao.delete(id);
    }

    @Override
    public List<ActivityPrizeOptionDto> queryActivityOptionsByConfigId(Long configId,String activityType) {
        return activityPrizeOptionDao.selectActivityOptionsByConfigId(configId, activityType);
    }

    @Override
    public ActivityPrizeOptionDto find(Long id) {
        return activityPrizeOptionDao.find(id);
    }

}

