/**
 * Project Name:activity-center-biz
 * File Name:TodayRobConfigService.java
 * Package Name:cn.com.duiba.activity.center.biz.service.rob
 * Date:2016年7月26日下午2:23:02
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.rob;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;

/**
 * ClassName:TodayRobConfigService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午2:23:02 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface TodayRobConfigService {

    /**
     * 根据id查询
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public TodayRobConfigDto find(Long configId);
    
    /**
     * 编辑/保存
     * @author zp
     * @param todayRobConfigDto
     * @return
     * @since JDK 1.6
     */
    public Long saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto);
    
    /**
     * 分页查询
     * @author zp
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String,Object> params);
    
    /**
     * 分页count
     * @author zp
     * @param params
     * @return
     * @since JDK 1.6
     */
    public Integer findTodayRobConfigCount(Map<String,Object> params);
    
    /**
     * 删除活动
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public Boolean delTodayRobConfig(Long configId);
    
    /**
     * 状态改变
     * @author zp
     * @param configId
     * @param status
     * @return
     * @since JDK 1.6
     */
    public Boolean statusChange(Long configId,Integer status);
    
    /**
     * 排序
     * @author zp
     * @param configId
     * @param status
     * @return
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset,Integer pageSize);
    
    /**
     * 置顶
     * @author zp
     * @param id
     * @param switches
     * @param stickyTime
     * @return
     * @since JDK 1.6
     */
    public Boolean updateStickyTime(Long id, Integer switches, Date stickyTime);
    
    /**
     * 更新参与次数
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Boolean updateVisitTime(Long id);
}

