package cn.com.duiba.activity.center.biz.tools.service;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service
public class SmsRemindService {
	
	public String sendCreditsAlarmSms(String phone, String appName,Integer failNum ,Integer success) throws Exception{
		CloseableHttpClient client = HttpClientBuilder.create().build();
		HttpPost post = new HttpPost("http://yunpian.com/v1/sms/send.json");
		List<NameValuePair> params = new ArrayList<NameValuePair>();
		params.add(new BasicNameValuePair("mobile", phone));
		params.add(new BasicNameValuePair("text", "【兑吧科技】"+appName+"今日扣积分请求失败次数达到"+failNum+"次(共计"+(failNum+success)+"次,失败率"+getFailPercentRate(failNum,success)+"),请确认系统是否有异常情况"));
		params.add(new BasicNameValuePair("apikey","dd66615d922f2519ff134c0df909e505"));
		post.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
		CloseableHttpResponse response = client.execute(post);
		return EntityUtils.toString(response.getEntity());
	}
	
	public String sendDevExceptionAlarmSms(String phone, String appName, Integer count) throws Exception{
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost("http://yunpian.com/v1/sms/send.json");
        List<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("mobile", phone));
        params.add(new BasicNameValuePair("text", "【兑吧科技】您的应用"+appName+",今日异常订单数额已达"+count+"条，请尽快进入后台基础配置-异常订单，查看订单异常原因，排查您的接口状态是否健康"));
        params.add(new BasicNameValuePair("apikey","dd66615d922f2519ff134c0df909e505"));
        post.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
        CloseableHttpResponse response = client.execute(post);
        return EntityUtils.toString(response.getEntity());
    }
	
	private String getFailPercentRate(Integer failNum,Integer successNum){
	    NumberFormat format = NumberFormat.getPercentInstance();// 获取格式化类实例 
        format.setMinimumFractionDigits(2);// 设置小数位 
        return format.format(Double.parseDouble(failNum + "") / Double.parseDouble(successNum + failNum + ""));// 打印计算结果 
	}
}
