package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreConsumeStockDto;
import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreConsumerStockService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.service.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 *
 * Created by wenqi.huang on 16/5/23.
 */
@Service
public class ActStockConsumerBo {

    //from ActStockConsumerService in credits

    private static Logger log = LoggerFactory.getLogger(ActStockConsumerBo.class);
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private ActPreConsumerStockService actPreConsumerStockService;

    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public void consumeActStock(Long prizeId, String bizId,String bizSource,Long appId) throws BusinessException {
        Long relationPrizeId = prizeId;
        String relationType = bizSource;

        ActPreStockDto actPreStock = findActValidStock(relationPrizeId, relationType, appId);
        if(null == actPreStock){
            throw new BusinessException("预分配库存不存在");
        }
        Long preStockId = actPreStock.getId();

        //锁
        ActPreStockDto actPreStockLock = actPreStockSerivce.findByLock(preStockId);

        if(null == actPreStockLock){
            throw new BusinessException("预分配库存不存在");
        }
        if(actPreStockLock.getPrizeQuantity() != null && actPreStockLock.getPrizeQuantity() <= 0){
            throw new BusinessException("预分配库存不足");
        }
        int ret = actPreStockSerivce.decrementRemaining(preStockId);
        if (ret < 1) {
            throw new BusinessException("更新兑吧活动奖项预分配库存异常");
        }
        Date now = new Date(System.currentTimeMillis()/1000*1000);

        ActPreConsumeStockDto actStockConsumer = new ActPreConsumeStockDto(true);
        actStockConsumer.setAppId(appId);
        actStockConsumer.setBizId(bizId);
        actStockConsumer.setBizSource(bizSource);
        actStockConsumer.setPreStockId(preStockId);
        actStockConsumer.setQuantity(1L);
        actStockConsumer.setAction(ActPreStockDto.ACTION_PAY);
        actStockConsumer.setGmtCreate(now);
        actStockConsumer.setGmtModified(now);

        actPreConsumerStockService.insert(actStockConsumer);
    }

    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public void paybackActStock(String bizId, String bizSource) throws BusinessException {
        ActPreConsumeStockDto consume = actPreConsumerStockService.findPreConsumerByBizPay(bizId, bizSource);

        if(null == consume){
            log.error("奖项库存消费记录不存在");
            return;
        }
        //锁
        ActPreStockDto actPreStockLock = actPreStockSerivce.findByLock(consume.getPreStockId());

        if(null == actPreStockLock){
            log.error("记录不存在");
            return;
        }
        int ret = actPreStockSerivce.incrementRemaining(actPreStockLock.getId());
        if (ret < 1) {
            throw new BusinessException("更新兑吧活动奖项预分配个数异常");
        }
        Date now = new Date(System.currentTimeMillis()/1000*1000);

        ActPreConsumeStockDto actStockConsumer = new ActPreConsumeStockDto(true);
        actStockConsumer.setAppId(consume.getAppId());
        actStockConsumer.setBizId(consume.getBizId());
        actStockConsumer.setBizSource(consume.getBizSource());
        actStockConsumer.setPreStockId(consume.getPreStockId());
        actStockConsumer.setQuantity(consume.getQuantity());
        actStockConsumer.setAction(ActPreStockDto.ACTION_BACK);
        actStockConsumer.setGmtCreate(now);
        actStockConsumer.setGmtModified(now);

        actPreConsumerStockService.insert(actStockConsumer);
    }

    public ActPreStockDto findActValidStock(Long relationPrizeId,
                                            String relationType, Long appId) {
        ActPreStockDto preStock = actPreStockSerivce.findPreStockByApp(relationPrizeId, relationType, appId);
        if(null == preStock){
            preStock = actPreStockSerivce.findPreStockByShare(relationPrizeId, relationType);
        }
        return preStock;
    }
}
