/**
 * Project Name:activity-center-biz File Name:GameCenterResourceDao.java Package
 * Name:cn.com.duiba.activity.center.biz.dao.gamecenter Date:2016年10月20日上午10:34:30 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.dao.gamecenter;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;

/**
 * ClassName:GameCenterResourceDao <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 上午10:34:30 <br/>
 *
 * @author zhuzhiyong
 * @version
 * @see
 */
public interface GameCenterResourceDao {

    /**
     * 新增资源.
     *
     * @param entity the entity
     * @return the int
     */
    int insert(GameCenterResourceEntity entity);

    /**
     * 查询指定资源位的活动资源.
     *
     * @param locationId the location id
     * @return the list
     */
    List<GameCenterResourceEntity> findResourceByLocationId(Long locationId);

    /**
     * 根据活动类型和ID查找资源信息,用于编辑,需查询所有状态的资源.
     *
     * @param activityType the activity type
     * @param activityId the activity id
     * @return the game center resource entity
     */
    List<GameCenterResourceEntity> findResourceByActivityTypeAndIdForEdit(Integer activityType, Long activityId);

    /**
     * findResource:根据活动类型,ID，资源位ID查询资源，只可能存在一条记录. <br/>
     *
     * @author zhuzhiyong
     * @param activityType
     * @param activityId
     * @param locationId
     * @return
     */
    GameCenterResourceEntity findResource(Integer activityType, Long activityId, Long locationId);

    /**
     * 根据活动类型查询资源.
     *
     * @param activtyType the activity type
     * @return the list
     */
    List<GameCenterResourceEntity> findResourceByActivityType(Integer activityType);

    /**
     * 修改资源状态.
     *
     * @param id the id
     * @param status the status
     * @return the int
     */
    int updateStatus(Long id, Byte status);

    /**
     * 查询除指定活动类型外的资源.
     *
     * @param activtyType the activty type
     * @param offset the offset
     * @param max the max
     * @return the list
     */
    List<GameCenterResourceEntity> findResourceExcludeActivityType(Integer activtyType, Integer offset, Integer max);

    /**
     * Count resource exclude activity type.
     *
     * @param activtyType the activity type
     * @return the integer
     */
    Integer countResourceExcludeActivityType(Integer activityType);
}
