/**
 * Project Name:activity-center-biz File Name:GameCenterResourceDaoImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.dao.gamecenter.impl Date:2016年10月20日上午11:00:52 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.dao.gamecenter.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;

/**
 * ClassName:GameCenterResourceDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 上午11:00:52 <br/>
 * 
 * @author zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("gameCenterResourceDao")
public class GameCenterResourceDaoImpl extends ActivityBaseDao implements GameCenterResourceDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }

    @Override
    public int insert(GameCenterResourceEntity entity) {
        return insert("insert", entity);
    }

    @Override
    public List<GameCenterResourceEntity> findResourceByLocationId(Long locationId) {
        return selectList("findResourceByLocationId", locationId);
    }

    @Override
    public List<GameCenterResourceEntity> findResourceByActivityTypeAndIdForEdit(Integer activityType,
                                                                                 Long activityId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityType", activityType);
        params.put("activityId", activityId);
        return selectList("findResourceByActivityTypeAndIdForEdit", params);
    }

    @Override
    public List<GameCenterResourceEntity> findResourceByActivityType(Integer activityType) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityType", activityType);
        return selectList("findResourceByActivityType", params);
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("status", status);
        return update("updateStatus", params);
    }

    @Override
    public List<GameCenterResourceEntity> findResourceExcludeActivityType(Integer activityType, Integer offset,
                                                                          Integer max) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityType", activityType);
        params.put("offset", offset);
        params.put("max", max);
        return selectList("findResourceExcludeActivityType", params);
    }

    @Override
    public Integer countResourceExcludeActivityType(Integer activityType) {
        return selectOne("countResourceExcludeActivityType", activityType);
    }

    @Override
    public GameCenterResourceEntity findResource(Integer activityType, Long activityId, Long locationId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityType", activityType);
        params.put("activityId", activityId);
        params.put("locationId", locationId);
        return selectOne("findResource", params);
    }
}
