/**
 * Project Name:activity-center-biz
 * File Name:GameSkinDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.gameskin.impl
 * Date:2016年9月28日下午5:36:46
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.gameskin.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.gameskin.GameSkinDao;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;

/**
 * ClassName:GameSkinDaoImpl <br/>
 * Date:     2016年9月28日 下午5:36:46 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class GameSkinDaoImpl extends ActivityBaseDao implements GameSkinDao{
    
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }

    @Override
    public GameSkinEntity selectById(Long id) {
        return selectOne("selectById",id);
    }

    @Override
    public Long insert(GameSkinEntity entity) {
        insert("insert",entity);
        return entity.getId();
    }

    @Override
    public Long update(GameSkinEntity entity) {
        update("update",entity);
        return entity.getId();
    }

    @Override
    public List<GameSkinEntity> selectByPage(int offset, int max) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("offset", offset);
        params.put("max", max);
        return selectList("selectByPage",params);
    }

    @Override
    public Long selectCount(String name) {
        return selectOne("selectCount",name);
    }

    @Override
    public List<GameSkinEntity> selectByType(Byte type) {
        return selectList("selectByType",type);
    }
    
    @Override
	public String getBrickContentById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("getGameSkinDomById", paramMap);
	}

	@Override
	public GameSkinEntity findNoContent(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findGameSkinNoContent", paramMap);
	}

}

