package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersAppDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;

import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

@Repository("guessOrdersAppDao")
public class GuessOrdersAppDaoImpl extends ActivityBaseDao implements GuessOrdersAppDao {
	
	@Override
	public void insert(GuessOrdersEntity entity, Long id){
		Map<String, Object> paramMap = getTbSuffixParamsMap(entity.getAppId());
		entity.setId(id);
        paramMap.put("mirror", entity);
        insert("insert", paramMap);
	}

	@Override
	public List<GuessOrdersEntity> findByLimit(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectList("findByLimit", paramMap);
	}

	@Override
	public Long totalCount(Map<String, Object> queryMap) {
		Long appId= (Long)queryMap.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.putAll(queryMap);
		return selectOne("totalCount", paramMap);
	}
	
	@Override
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(List<Long> ids, Long appId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("ids", ids);
		paramMap.put("appId", appId);
		return selectList("countFailByOperatingActivityIds", paramMap);
	}

	/**
	 * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
	 *
	 * @return
	 */
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS_APP;
	}
}
