package cn.com.duiba.activity.center.biz.dao.hdtool;

import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;

import java.util.List;
import java.util.Map;

/**
 * hdtool_orders表的app维度分表,活动工具订单业务DAO
 */
public interface AppHdtoolOrdersDao {

	/**
	 * 统计活动失败条数
	 */
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(Long appId, List<Long> ids);
	
	/**
	 * 分页查询
	 */
	public List<HdtoolOrdersEntity> findByLimit(Map<String, Object> queryParam);
	
	/**
	 * 统计条数
	 */
	public Long totalCount(Map<String, Object> queryParam);

	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersEntity> findByIds(Long appId, List<Long> ids);

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersEntity find(Long appId, Long id);

	/**
	 * 根据开发者订单号查询订单
	 */
	public HdtoolOrdersEntity findByAppAndDeveloperBizId(Long appId, String bizId);

	public List<HdtoolOrdersEntity> findHdtoolOrderLimit50(Long appId, Long activityId);

}
