package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolOptionsDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaHdtoolOptionsDaoImpl extends ActivityBaseDao implements DuibaHdtoolOptionsDao {
	@Override
	public List<DuibaHdtoolOptionsEntity> findByHdtoolId(Long hdtoolId) {
		return selectList("findByHdtoolId", hdtoolId);
	}

	@Override
	public int addRemainingById(Long id, Integer addRemaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("addRemaining", addRemaining);
		return update("addRemainingById", paramMap);
	}

	@Override
	public int subRemainingById(Long id, Integer subRemaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("subRemaining", subRemaining);
		return update("subRemainingById", paramMap);
	}

	@Override
	public int updateRemainingById(Long id, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("remaining", remaining);
		return update("updateRemainingById", paramMap);
	}

	@Override
	public Integer findRemaingForupdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findRemaingForupdate", paramMap);
	}

	/**
	 * 根据活动ID查询奖项
	 */
	@Override
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolId(Long hdtoolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdtoolId", hdtoolId);
		return selectList("findOptionsByDuibaHdtoolId", paramMap);
	}

	/**
	 * 根据活动ID查询奖项
	 */
	@Override
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds) {
		if(hdtoolIds == null || hdtoolIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdtoolIds", hdtoolIds);
		return selectList("findOptionsByDuibaHdtoolIds", paramMap);
	}

	/**
	 * 查询活动奖项个数
	 */
	@Override
	public Integer countOptionsByHdtoolId(Long hdtoolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdtoolId", hdtoolId);
		return selectOne("countOptionsByHdtoolId", paramMap);
	}

	/**
	 * 根据ID查询
	 */
	@Override
	public DuibaHdtoolOptionsEntity findOptionById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findOptionById", paramMap);
	}

	@Override
	public DuibaHdtoolOptionsEntity findOptionByIdForupdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findOptionByIdForupdate", paramMap);
	}

	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	@Override
	public List<Long> findHasUserdHdIds(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return selectList("findHasUserdHdIds", paramMap);
	}

	/**
	 * 减奖品数量
	 */
	@Override
	public int decrementOptionRemaining(@Param("id") Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("decrementOptionRemaining", paramMap);
	}

	/**
	 * 加奖品数量
	 */
	@Override
	public int incrementOptionRemaining(@Param("id") Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("incrementOptionRemaining", paramMap);
	}

	/**
	 * 删除奖项
	 */
	@Override
	public int deleteOptions(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("oaoList", ids);
		return update("deleteOptions", paramMap);
	}

	/**
	 * 修改奖项
	 */
	@Override
	public int updateHdtoolPrize(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		return update("updateHdtoolPrize", duibaHdToolOptionDO);
	}

	/**
	 * 新增兑换活动工具奖项
	 */
	@Override
	public void insertHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		insert("insertHdtoolOption", duibaHdToolOptionDO);
	}

	/**
	 * 修改兑吧活动工具
	 */
	@Override
	public int updateHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		return update("updateHdtoolOption", duibaHdToolOptionDO);
	}


	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
