/**
 * Project Name:activity-center-biz
 * File Name:TodayRobSeckillConfigDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.rob
 * Date:2016年9月30日上午10:44:25
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.rob;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;

/**
 * ClassName:TodayRobSeckillConfigDao <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年9月30日 上午10:44:25 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface TodayRobSeckillConfigDao {

    TodayRobSeckillConfigEntity selectPushedActivity(Long activityId);

    void updatePushStatusAndTime(Long todayRobSeckillConfigId, String pushStatus, Date pushTime);

    /**
     * 查询推送未成功的秒杀活动
     * @return
     */
    List<TodayRobSeckillConfigEntity> findUnsuccessPushList();
    
    /**
	 * 查询秒杀区间下秒杀活动列表
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	List<TodayRobSeckillConfigEntity> selectSeckillConfigs(Long todayRobSeckillId);
	
	/**
	 * 批量插入秒杀配置项  秒杀活动
	 * @param insertParamList
	 * @return
	 */
	Boolean  insertSeckillConfigBatch(List<TodayRobSeckillConfigEntity> insertParamList);
	
	/**
	 * 批量更新秒杀配置项  秒杀活动
	 * @param updateParamList 
	 * @return
	 */
	Boolean  updateSeckillConfigBatch(List<TodayRobSeckillConfigEntity> updateParamList);
	/**
	 * 批量删除秒杀配置项  秒杀活动
	 * @param delIds 
	 * @return
	 */
	Boolean  deleteSeckillConfigBatch(List<Long> delIds);
	/**
	 *  批量查询秒杀区间下秒杀活动列表 
	 * @param todayRobSeckillId
	 * @return
	 */
	List<TodayRobSeckillConfigEntity> selectSeckillConfigByIdss(List<Long> todayRobSeckillId);
	
}

