/**
 * Project Name:activity-center-biz File Name:TodayRobSeckillConfigDaoImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.dao.rob.impl Date:2016年9月30日上午10:45:17 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.dao.rob.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillConfigDao;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;

/**
 * ClassName:TodayRobSeckillConfigDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年9月30日 上午10:45:17 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository
public class TodayRobSeckillConfigDaoImpl extends ActivityBaseDao implements TodayRobSeckillConfigDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public TodayRobSeckillConfigEntity selectPushedActivity(Long activityId) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("activityId", activityId);
        return selectOne("selectPushedActivity", map);
    }

    @Override
    public void updatePushStatusAndTime(Long todayRobSeckillConfigId, String pushStatus, Date pushTime) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", todayRobSeckillConfigId);
        map.put("pushStatus", pushStatus);
        map.put("pushTime", pushTime);
        update("updatePushStatusAndTime", map);
    }

    @Override
    public List<TodayRobSeckillConfigEntity> findUnsuccessPushList() {
        return selectList("findUnsuccessPushList");
    }
    
    @Override
	public List<TodayRobSeckillConfigEntity> selectSeckillConfigs(Long todayRobSeckillId) {
		return selectList("selectSeckillConfigs",todayRobSeckillId);
	}
    
    @Override
	public Boolean insertSeckillConfigBatch(List<TodayRobSeckillConfigEntity> insertParamList) {
		insert("insertSeckillConfigBatch", insertParamList);
		return true;
	}

	@Override
	public Boolean updateSeckillConfigBatch(List<TodayRobSeckillConfigEntity> updateParamList) {
		update("updateSeckillConfigBatch", updateParamList);
		return true;
	}

	@Override
	public Boolean deleteSeckillConfigBatch(List<Long> delIds) {
		if(delete("deleteSeckillConfigBatch", delIds) >0){
			return true;
		}
		return false;
	}
	
	@Override
	public List<TodayRobSeckillConfigEntity> selectSeckillConfigByIdss(List<Long> todayRobSeckillIds) {
		return selectList("selectSeckillConfigByIdss",todayRobSeckillIds);
	}
}
