package cn.com.duiba.activity.center.biz.dao.rob.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillDao;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;

@Repository
public class TodayRobSeckillDaoImpl extends ActivityBaseDao implements TodayRobSeckillDao {

	@Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

	

	@Override
	public TodayRobSeckillEntity selectSeckillById(Long todayRobSeckillId) {
		return selectOne("selectSeckillById",todayRobSeckillId);
	}

	@Override
	public List<TodayRobSeckillEntity> selectTodayRobSeckillList(int pageNum,int pageSize) {
		Map<String,Object> map = new HashMap<String,Object>();
	    map.put("pageNum", pageNum);
	    map.put("pageSize", pageSize);
		return selectList("selectTodayRobSeckillList",map);
	}

	@Override
	public Long selectTodayRobSeckillCount() {
		return selectOne("selectTodayRobSeckillCount");
	}

	@Override
	public Boolean deleteTodayRobSeckill(long todayRobSeckillId) {
		if(delete("deleteTodayRobSeckill", todayRobSeckillId) >0){
			return true;
		}
		return false;
		
	}

	@Override
	public Boolean updateTodayRobSeckill(long todayRobSeckillId, boolean enable) {
		Map<String,Object> map = new HashMap<String,Object>();
	    map.put("todayRobSeckillId",todayRobSeckillId);
	    map.put("enable", enable);
		update("updateTodayRobSeckill", map);
		return true;
	}
	

	@Override
	public Boolean insertSeckill(TodayRobSeckillEntity trc) {
		if(insert("insertSeckill", trc) >0){
			return true;
		}
		return false;
	}

	@Override
	public Boolean updateSeckill(TodayRobSeckillEntity trc) {
		if(update("updateSeckill", trc) >0){
			return true;
		}
		return false;
	}

    @Override
    public void disableActivityBeforeDate(Date date) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("date", date);
        update("disableActivityBeforeDate", map);
    }

    @Override
    public List<TodayRobSeckillEntity> selectSeckillBeforeTime(Date beforeDate, int limit) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("beforeDate", beforeDate);
        map.put("limit", limit);
        return selectList("selectSeckillBeforeTime",map);
    }

    @Override
    public List<TodayRobSeckillEntity> selectSeckillAfterTime(Date afterDate, int limit) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("afterDate", afterDate);
        map.put("limit", limit);
        return selectList("selectSeckillAfterTime",map);
    }



    @Override
    public List<Long> findEnableTodayRobSeckillIds() {
        return selectList("findEnableTodayRobSeckillIds");
    }

}
