package cn.com.duiba.activity.center.biz.dao.seconds_kill.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityAppSpecifyEntity;

@Repository
public class DuibaSecondsKillActivityAppSpecifyDaoImpl extends ActivityBaseDao implements DuibaSecondsKillActivityAppSpecifyDao {

	@Override
	public DuibaSecondsKillActivityAppSpecifyEntity findByDuibaActivityAndApp(Long duibaSecondsKillActivityId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
		paramMap.put("appId", appId);
		return selectOne("findByDuibaActivityAndApp",paramMap);
	}

	@Override
	public List<DuibaSecondsKillActivityAppSpecifyEntity> findByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
		return selectList("findByDuibaSecondsKillActivityId", paramMap);
	}

	@Override
	public void insert(DuibaSecondsKillActivityAppSpecifyEntity duibaSecondsKillActivityAppSpecify) {
		insert("insert", duibaSecondsKillActivityAppSpecify);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		delete("delete", paramMap);
	}

	@Override
	public DuibaSecondsKillActivityAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public DuibaSecondsKillActivityAppSpecifyEntity findByDuibaSecondsKillActivityAndApp(Long duibaSecondsKillActivityId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaSecondsKillActivityId", duibaSecondsKillActivityId);
		paramMap.put("appId", appId);
		return selectOne("findByDuibaSecondsKillActivityAndApp", paramMap);
	}
	
	@Override
	public List<DuibaSecondsKillActivityAppSpecifyEntity> findByDuibaActivityIdsAndApp(List<Long> activityIds, Long appId){
		if(activityIds == null || activityIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		paramMap.put("ids", activityIds);
		return selectList("findByDuibaActivityIdsAndApp", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
