package cn.com.duiba.activity.center.biz.dao.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryStockConsumeDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryStockConsumeEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yansen on 16/6/21.
 */
@Repository
public class SingleLotteryStockConsumeDaoImpl extends ActivityBaseDao implements SingleLotteryStockConsumeDao {
    @Override
    public int insert(SingleLotteryStockConsumeEntity singleLotteryStockConsumeDO) {
        return insert("insert", singleLotteryStockConsumeDO);
    }

    @Override
    public SingleLotteryStockConsumeEntity findByBizIdAndSource(String bizId,String bizSource) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("bizId", bizId);
        map.put("bizSource", bizSource);
        return selectOne("findByBizIdAndSource",map);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
