/**
 * Project Name:activity-center-biz File Name:TodayRobSeckillRestartJob.java Package
 * Name:cn.com.duiba.activity.center.biz.job Date:2016年10月8日下午2:01:07 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.activity.center.biz.job;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.biz.domain.PushAppsConfig;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.activity.center.common.util.AppLogUtil;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;

/**
 * 推送失败的秒杀任务补偿 Date: 2016年10月8日 下午2:01:07 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class TodayRobSeckillRestartJob extends AbstractSimpleElasticJob {

    private static Logger          log = LoggerFactory.getLogger(TodayRobSeckillRestartJob.class);

    @Autowired
    private TodayRobSeckillService todayRobSeckillService;

    @Autowired
    private TodayRobSeckillBo      todayRobSeckillBo;

    @Autowired
    private CenterConfigService    centerConfigService;

    @Override
    public void process(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn(log, "################# 今日必抢秒杀免单定时任务-秒杀任务推送补偿，开始执行 #################");
        List<TodayRobSeckillConfigEntity> list = todayRobSeckillService.findUnsuccessPushList();
        if (CollectionUtils.isEmpty(list)) {
            AppLogUtil.warn(log, "没有需要补偿的推送任务");
            return;
        }
        CenterConfigEntity entity = centerConfigService.findPushAppsConfig();
        PushAppsConfig pushAppsConfig = new PushAppsConfig(entity);
        List<Long> appIdList = pushAppsConfig.getAppIdList();
        if(CollectionUtils.isEmpty(appIdList)){
            AppLogUtil.warn(log, "没有配置推送app列表");
            return;
        }
        todayRobSeckillBo.pushSeckillActivity(BeanUtils.copyList(list, TodayRobSeckillConfigDto.class), appIdList);
        AppLogUtil.warn(log, "################# 今日必抢秒杀免单定时任务-秒杀任务推送补偿，执行结束 #################");
    }
}
