package cn.com.duiba.activity.center.biz.plugin.buckle;

import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;


/**
 * describe : 扣积分service(单纯的扣积分)
 * @author  : cdm
 * @date    : 2016年10月20日 下午4:40:16
 */
public interface ConsumerCutCreditsService {

    /**
     * describe : 消耗积分
     * @author  : cdm
     * @date    : 2016年10月20日下午4:41:32
     * @param consumerId   用户ID
     * @param orderNum     订单编号
     * @param transfer
     * @param ip           IP
     * @param description  描述
     */
    public void asyncConsumerCredits(Long consumerId,String orderNum,String transfer,String ip,String description);
    
    /**
     * 扣积分失败回调
     * onCreditsFail:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param message
     * @param exception
     * @since JDK 1.6
     */
    public void onCreditsFail(CreditsCallbackMessage message,ActivityOrderDto order);
    
    /**
     * 扣积分成功
     * @author zp
     * @param message
     * @since JDK 1.6
     */
    public void onCreditsSuccess(CreditsCallbackMessage message);
    
    /**
     * kafka消息回调 
     * @author zp
     * @param message
     * @since JDK 1.6
     */
    public void creditsCallback(CreditsCallbackMessage message);
}

